package org.eclipse.hyades.logging.jvm.threadanalysis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.*;

import org.eclipse.hyades.logging.events.EventItemsFactory;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.IAssociationEngine;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IReportSituation;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.IExtendedDataElement;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;


/**
 * @author duncan
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ThreadDumpProcessorImpl implements ThreadDumpProcessor {

	private	ISimpleEventFactory         _simpleEventFactory;
	private	IComponentIdentification	_compId;
	private ISituation					_situation;
	private IAssociationEngine 			_associationEngine; 


	/* (non-Javadoc)
	 * @see com.ibm.ws.performance.threadanalyzer.getthreaddump.ThreadDumpProcessor#generateCBE(com.ibm.ws.performance.threadanalyzer.DumpData)
	 */
	public Vector generateCBEs(DumpData dd) {

		Vector             			cbes = new Vector();
		IExtendedDataElement 		xdeThdDump, xdeThreads, xdeMonitors;
		ICommonBaseEvent			cbeThdDump, cbeThreads, cbeMonitors;
        IAssociatedEvent 			associatedThreadsEvent 	= _simpleEventFactory.createAssociatedEvent();

        _compId.setComponent(dd.getDumpingJvmName());
        
        cbeThdDump 	= createCBE("ThreadDump", null		, cbes);
		cbeThdDump.addExtendedDataElement("Type","Java");
		cbeThdDump.addExtendedDataElement("Description",dd.getDescription());
		cbeThdDump.addExtendedDataElement("DisplayName",dd.getDisplayName());
 
        cbeThreads = createCBE("Threads"	, cbeThdDump, cbes);
		xdeThreads = cbeThdDump.addExtendedDataElementWithIntValue("Threads",dd.getThreads().size());
		addThreads(dd, xdeThreads, cbeThreads, cbes);

		cbeMonitors	= createCBE("Monitors"	, cbeThdDump, cbes);
		xdeMonitors = cbeThdDump.addExtendedDataElementWithIntValue("Monitors",dd.getMonitors().size());
		addMonitors(dd, xdeMonitors, cbeMonitors, cbes);

		return cbes;
	}

	/**
	 * @param string
	 * @return
	 */
	private ICommonBaseEvent createCBE(String type, ICommonBaseEvent parentCbe, Vector cbes) {
		ICommonBaseEvent childCbe = _simpleEventFactory.createCommonBaseEvent("CBE:"+type,(new Date()).getTime());
		
		childCbe.setSeverity((short) 10);	
		childCbe.setMsg(type);
		childCbe.setSourceComponentId(_compId);
		childCbe.setSituation(_situation);
		if (parentCbe !=null) {
			IAssociatedEvent cbeAssociatedEvent = _simpleEventFactory.createAssociatedEvent();
			cbeAssociatedEvent.setAssociationEngineInfo(_associationEngine);
			cbeAssociatedEvent.addResolvedEvent(childCbe.getGlobalInstanceId());
			parentCbe.addAssociatedEvent(cbeAssociatedEvent);
		}
		cbes.add(childCbe);
		
		return childCbe; 
	}

	/**
	 * @param dd
	 * @param xdeThreads
	 * @param cbeThreads
	 */
	private void addThreads(DumpData dd, IExtendedDataElement xdeThreads, ICommonBaseEvent cbeThreads, Vector cbes) {
		ICommonBaseEvent		cbeCurrThread;
		IExtendedDataElement 	xdeCurrThread;
		Enumeration 			enumThreads;
		Thd						currThd;
		int i=0;

	 	cbeThreads.addExtendedDataElementWithIntValue("Thread Count",dd.getThreads().size());
	 	enumThreads = dd.getThreadEnum();
	 	
	 	while ((currThd = dd.getNextThread(enumThreads))!=null) {
//	 		createThreadXde(xdeThreads, currThd, i);		// imbed thread xdes in root cbe as well	
	 		createThreadCbe(cbeThreads, currThd, i, cbes);
		 	i++;
	 	}    
	}

	/**
	 * @param xdeCurrThread
	 * @param currThd
	 */
	private IExtendedDataElement createThreadXde(IExtendedDataElement xdeThreads, Thd currThd, int i) {
		IExtendedDataElement 	xdeStkEntries, xdeStkEntriesNative;

		IExtendedDataElement 	xdeCurrThread = xdeThreads.addChildWithIntValue("Thread_"+i,i);
		
 		xdeCurrThread.addChild("threadId",currThd.getThreadId());
 		xdeCurrThread.addChild("name",currThd.getName());
 		xdeCurrThread.addChild("priority",currThd._priority);
 		xdeCurrThread.addChild("state",currThd._state);
 		xdeCurrThread.addChildWithIntValue("waitMonitorID",currThd.getWaitMonitorId());
 		if(currThd._waitMonitor != null) {
	 		xdeCurrThread.addChild("waitMonitorKey",currThd._waitMonitor.getName());
 		}
		xdeStkEntries = xdeCurrThread.addChildWithIntValue("StackEntries",currThd.getStkSize());		
		xdeStkEntriesNative = xdeCurrThread.addChildWithIntValue("StackEntriesNative",currThd.getStkNativeSize());
		addStackEntries(currThd, xdeStkEntries);
 		addStackEntriesNative(currThd, xdeStkEntriesNative);
		return xdeCurrThread;	 		
	}

	/**
	 * @param currThd
	 * @param i	 
	 *	 */
	private ICommonBaseEvent createThreadCbe(ICommonBaseEvent parentCbe, Thd currThd, int i, Vector cbes) {
		IExtendedDataElement 	xdeStkEntries, xdeStkEntriesNative;

		ICommonBaseEvent 		cbeCurrThread = createCBE("Thread"+i, parentCbe, cbes);
	 	cbeCurrThread.addExtendedDataElementWithIntValue("Thread Index",i);
	 	 		
		cbeCurrThread.addExtendedDataElement("threadId",currThd.getThreadId());
 		cbeCurrThread.addExtendedDataElement("name",currThd.getName());
 		cbeCurrThread.addExtendedDataElement("priority",currThd._priority);
 		cbeCurrThread.addExtendedDataElement("state",currThd._state);
 		cbeCurrThread.addExtendedDataElementWithIntValue("waitMonitorID",currThd.getWaitMonitorId());
 		if(currThd._waitMonitor != null) {
	 		cbeCurrThread.addExtendedDataElement("waitMonitorKey",currThd._waitMonitor.getName());
 		}
 		xdeStkEntries = cbeCurrThread.addExtendedDataElementWithIntValue("StackEntries",currThd.getStkSize());
 		xdeStkEntriesNative = cbeCurrThread.addExtendedDataElementWithIntValue("StackEntriesNative",currThd.getStkNativeSize());
 		addStackEntries(currThd,xdeStkEntries);
 		addStackEntriesNative(currThd,xdeStkEntriesNative);
 		return cbeCurrThread;
	}

	/**
	 * @param currThd
	 * @param xdeCurrThread
	 */
	private void addStackEntries(Thd currThd, IExtendedDataElement xdeStkEntries) {
		IExtendedDataElement 	xdeCurrStkEntry;
		StkEntry				currStkEntry;

 		for (int j=0; j<currThd.getStkSize(); j++) {
 			currStkEntry=currThd.getStkEntry(j);
 			xdeCurrStkEntry=xdeStkEntries.addChildWithIntValue("StkEntry_"+j,j);
 			xdeCurrStkEntry.addChild("module",currStkEntry._module);
 			xdeCurrStkEntry.addChild("pkg",currStkEntry._pkg);
 			xdeCurrStkEntry.addChild("method",currStkEntry._method);
 			xdeCurrStkEntry.addChildWithIntValue("lineno",currStkEntry._lineno);
 			xdeCurrStkEntry.addChildWithBooleanValue("isNative",currStkEntry._isNative);
 		}
		return;
	}

	/**
	 * @param currThd
	 * @param xdeCurrThread
	 */
	private void addStackEntriesNative(Thd currThd, IExtendedDataElement xdeStkEntriesNative) {
		IExtendedDataElement 	xdeCurrStkEntryNative;
		StkEntryNative			currStkEntryNative;

 		for (int j=0; j<currThd.getStkNativeSize(); j++) {
 			currStkEntryNative=currThd.getStkEntryNative(j);
 			xdeCurrStkEntryNative=xdeStkEntriesNative.addChildWithIntValue("StkEntryNative_"+j,j);
 			xdeCurrStkEntryNative.addChild("function",currStkEntryNative._function);
 			xdeCurrStkEntryNative.addChild("hexAddress",currStkEntryNative._hexAddress);
 		}
		return;
	}
	
	/**
	 * @param dd
	 * @param xdeMonitors
	 * @param cbeMonitors
	 */
	private void addMonitors(DumpData dd, IExtendedDataElement xdeMonitors, ICommonBaseEvent cbeMonitors, Vector cbes) {

		Enumeration 			enumMonitors;
		Monitor					currMon;
		int i=0;
			
		cbeMonitors.addExtendedDataElementWithIntValue("Monitor Count",dd.getMonitors().size());
	 	enumMonitors = dd.getMonitorEnum();
	 	while ((currMon = dd.getNextMonitor(enumMonitors))!=null) {
//	 		createMonitorXde(xdeMonitors, currMon, i);   	// imbed monitor xdes in root cbe as well
  	 		createMonitorCbe(cbeMonitors, currMon, i, cbes);   
	 		i++;
	 	}    
	}
	/**
	 * @param xdeMonitors
	 * @param currMon
	 * @param i
	 */
	private void createMonitorXde(IExtendedDataElement xdeMonitors, Monitor currMon, int i) {
		IExtendedDataElement xdeCurrMonitor = xdeMonitors.addChildWithIntValue("Monitor"+i,i);
		IExtendedDataElement xdeWaiters;
		int					 waitersSize	= currMon._waiters.size();
	 		
	 	xdeCurrMonitor.addChild("name",currMon.getName());
	 	if (currMon._owner!=null) {
	 		xdeCurrMonitor.addChild("ownerThreadId",currMon._owner._threadId);
	 		xdeCurrMonitor.addChild("ownerThreadName",currMon._owner.getName());
	 	}	
	 	xdeCurrMonitor.addChildWithIntValue("monitor_type",currMon._monitor_type);
	 	
		if (waitersSize>0) {
			xdeWaiters = xdeCurrMonitor.addChildWithIntValue("Waiters",waitersSize);
			addWaiters(currMon,xdeWaiters);
		}	
	}
	/**
	 * @param cbeMonitors
	 * @param currMon
	 * @param i
	 * @param cbes
	 */
	private void createMonitorCbe(ICommonBaseEvent parentCbe, Monitor currMon, int i, Vector cbes) {
		ICommonBaseEvent 		cbeCurrMonitor = createCBE("Monitor"+i, parentCbe, cbes);
		IExtendedDataElement 	xdeWaiters;
		int						waitersSize	= currMon._waiters.size();
	 	cbeCurrMonitor.addExtendedDataElementWithIntValue("Monitor Index",i);
		cbeCurrMonitor.addExtendedDataElement("name",currMon.getName());
	 	if (currMon._owner!=null) {
	 		cbeCurrMonitor.addExtendedDataElement("ownerThreadId",currMon._owner._threadId);
	 		cbeCurrMonitor.addExtendedDataElement("ownerThreadName",currMon._owner.getName());
	 	}	
	 	cbeCurrMonitor.addExtendedDataElementWithIntValue("monitor_type",currMon._monitor_type);
		if (waitersSize>0) {
			xdeWaiters = cbeCurrMonitor.addExtendedDataElementWithIntValue("Waiters",waitersSize);
			addWaiters(currMon,xdeWaiters);
		}	
	}
	/**
	 * @param currMon
	 * @param xdeCurrMonitor
	 */
	private void addWaiters(Monitor currMon, IExtendedDataElement xdeWaiters) {
		IExtendedDataElement 	xdeCurrWaiter;
		Thd     				currWaiter;
		Vector					waiters=currMon._waiters;
		int						waitersSize=currMon._waiters.size();

	 	for (int j=0; j<waitersSize; j++) {
	 		currWaiter=(Thd)waiters.elementAt(j);
	 		xdeCurrWaiter=xdeWaiters.addChildWithIntValue("Waiter_"+j,j);
	 		xdeCurrWaiter.addChild("ThreadId",currWaiter.getThreadId());
	 		xdeCurrWaiter.addChild("ThreadName",currWaiter.getName());
 		}
		return;
	}

	/**
	 *
	 */
	public ThreadDumpProcessorImpl() {
		super();
		String hostname = null;
		_simpleEventFactory = SimpleEventFactoryImpl.getInstance();
		try {
			hostname = InetAddress.getLocalHost().getHostName();
		} catch (UnknownHostException e) {
			hostname = "localhost"; // if we couldn't resolve the local hostname we just print "localhost"
		}
		try {
			IReportSituation repSituation;
		    repSituation=_simpleEventFactory.createReportSituation();
			repSituation.setReportCategory("Trace");
			_situation 	= EventItemsFactory.createISituation("ReportSituation", repSituation);	
			
			_compId = EventItemsFactory.createIComponentIdentification(
					"ProductName"			/*componentIdType*/,"Dummy" /*component*/, 	
					"Thread/Monitor dump" 	/*subComponent*/,	"Hostname" /*locationType*/, 	
					hostname 				/*location*/, 		null /*application*/, 
					null 					/*executionEnv*/, 	null /*instanceId*/, 	
					null 					/*processId*/, 		null /*threadId*/, 		
					"JAVA JVM" 				/*componentType*/);
			
			_associationEngine=_simpleEventFactory.createAssociationEngine();
			_associationEngine.setType("Root");
			_associationEngine.setName("Root");
					
		} catch (Exception e) {
			e.printStackTrace();
		}	
	}	
	
}