package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;

import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.util.EventMessages;
import org.eclipse.hyades.logging.core.Guid;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1.
 * @since 1.0.1
 * <!-- end-user-doc -->
 * @generated
 */
public class EventFactoryImpl extends EFactoryImpl implements EventFactory, Serializable, Referenceable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -4678401577300618645L;

    /**
     * Name of the reference address for the mediation handlers in JNDI.
     * <P>
     * The <code>getReference</code> method encodes the mediation handlers in
     * their serialized form inside a reference address and uses this name
     * for that address.
     */
    public final static String CBE_INSTANCE_ADDRESS = "CBE.MediationHandler";

    /**
     * Prefix added to all guids produced from this class.
     * 
     * @see #createGlobalInstanceId()
     */
    static final private String GUID_PREFIX = "CE";

    /**
     * Classname for trace/log 
     */
    final private static String CLASS_NAME = EventFactoryObjectFactory.class.getName();

    /**
     * Content handler associated to this factory.
     */
    private ContentHandler contentHandler;

    /**
     * Creates and instance of the factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EventFactoryImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EventPackage getEventPackage() {
        return (EventPackage) getEPackage();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static EventPackage getPackage() {
        return EventPackage.eINSTANCE;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case EventPackage.ASSOCIATED_EVENT :
                return createAssociatedEvent();
            case EventPackage.ASSOCIATION_ENGINE :
                return createAssociationEngine();
            case EventPackage.AVAILABLE_SITUATION :
                return createAvailableSituation();
            case EventPackage.COMMON_BASE_EVENT :
                return createCommonBaseEvent();
            case EventPackage.COMPONENT_IDENTIFICATION :
                return createComponentIdentification();
            case EventPackage.CONFIGURE_SITUATION :
                return createConfigureSituation();
            case EventPackage.CONNECT_SITUATION :
                return createConnectSituation();
            case EventPackage.CONTEXT_DATA_ELEMENT :
                return createContextDataElement();
            case EventPackage.CREATE_SITUATION :
                return createCreateSituation();
            case EventPackage.DEPENDENCY_SITUATION :
                return createDependencySituation();
            case EventPackage.DESTROY_SITUATION :
                return createDestroySituation();
            case EventPackage.EXTENDED_DATA_ELEMENT :
                return createExtendedDataElement();
            case EventPackage.FEATURE_SITUATION :
                return createFeatureSituation();
            case EventPackage.MSG_CATALOG_TOKEN :
                return createMsgCatalogToken();
            case EventPackage.MSG_DATA_ELEMENT :
                return createMsgDataElement();
            case EventPackage.OTHER_SITUATION :
                return createOtherSituation();
            case EventPackage.REPORT_SITUATION :
                return createReportSituation();
            case EventPackage.REQUEST_SITUATION :
                return createRequestSituation();
            case EventPackage.SITUATION :
                return createSituation();
            case EventPackage.START_SITUATION :
                return createStartSituation();
            case EventPackage.STOP_SITUATION :
                return createStopSituation();
            default :
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public AssociatedEvent createAssociatedEvent() {
        AssociatedEventImpl associatedEvent = new AssociatedEventImpl();
        return associatedEvent;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public AssociationEngine createAssociationEngine() {
        AssociationEngineImpl associationEngine = new AssociationEngineImpl();
        return associationEngine;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public AvailableSituation createAvailableSituation() {
        AvailableSituationImpl availableSituation = new AvailableSituationImpl();
        return availableSituation;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.EventFactory#createCommonBaseEvent()
     */
    public CommonBaseEvent createCommonBaseEvent() {
        CommonBaseEvent result = createCommonBaseEventGen();
        ((CommonBaseEventImpl) result).setContentHandler(contentHandler);
        return result;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public CommonBaseEvent createCommonBaseEventGen() {
        CommonBaseEventImpl commonBaseEvent = new CommonBaseEventImpl();
        return commonBaseEvent;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.EventFactory#createCommonBaseEvent(String, long)
     */
    public CommonBaseEvent createCommonBaseEvent(String extensionName, long creationTime) {
        CommonBaseEvent result = createCommonBaseEvent();
        result.setExtensionName(extensionName);
        result.setCreationTimeAsLong(creationTime);
        return result;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.EventFactory#createCommonBaseEvent(String)
     */
    public CommonBaseEvent createCommonBaseEvent(String extensionName) {
        CommonBaseEvent result = createCommonBaseEvent();
        result.setExtensionName(extensionName);
        return result;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComponentIdentification createComponentIdentification() {
        ComponentIdentificationImpl componentIdentification = new ComponentIdentificationImpl();
        return componentIdentification;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ConfigureSituation createConfigureSituation() {
        ConfigureSituationImpl configureSituation = new ConfigureSituationImpl();
        return configureSituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ConnectSituation createConnectSituation() {
        ConnectSituationImpl connectSituation = new ConnectSituationImpl();
        return connectSituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ContextDataElement createContextDataElement() {
        ContextDataElementImpl contextDataElement = new ContextDataElementImpl();
        return contextDataElement;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public CreateSituation createCreateSituation() {
        CreateSituationImpl createSituation = new CreateSituationImpl();
        return createSituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DependencySituation createDependencySituation() {
        DependencySituationImpl dependencySituation = new DependencySituationImpl();
        return dependencySituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DestroySituation createDestroySituation() {
        DestroySituationImpl destroySituation = new DestroySituationImpl();
        return destroySituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ExtendedDataElement createExtendedDataElement() {
        ExtendedDataElementImpl extendedDataElement = new ExtendedDataElementImpl();
        return extendedDataElement;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public FeatureSituation createFeatureSituation() {
        FeatureSituationImpl featureSituation = new FeatureSituationImpl();
        return featureSituation;
    }

    /**
     * Produces a globally unique identifier according to the Internet draft
     * draft-leach-uuids-guids-01 algorithm. 
     * @link {http://www.opengroup.org/dce/info/draft-leach-uuids-guids-01.txt}
     * 
     * @return               a globally unique identifier according to the 
     *                       algorith above.
     */
    public String createGlobalInstanceId() {
        Guid guid = new Guid();

        return (GUID_PREFIX + guid.toString());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public MsgCatalogToken createMsgCatalogToken() {
        MsgCatalogTokenImpl msgCatalogToken = new MsgCatalogTokenImpl();
        return msgCatalogToken;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public MsgDataElement createMsgDataElement() {
        MsgDataElementImpl msgDataElement = new MsgDataElementImpl();
        return msgDataElement;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public OtherSituation createOtherSituation() {
        OtherSituationImpl otherSituation = new OtherSituationImpl();
        return otherSituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ReportSituation createReportSituation() {
        ReportSituationImpl reportSituation = new ReportSituationImpl();
        return reportSituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public RequestSituation createRequestSituation() {
        RequestSituationImpl requestSituation = new RequestSituationImpl();
        return requestSituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Situation createSituation() {
        SituationImpl situation = new SituationImpl();
        return situation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public StartSituation createStartSituation() {
        StartSituationImpl startSituation = new StartSituationImpl();
        return startSituation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public StopSituation createStopSituation() {
        StopSituationImpl stopSituation = new StopSituationImpl();
        return stopSituation;
    }

    /**
     * Setter method for the <code>contentHandler</code> attribute.
     * 
     * @param value          the new value for the attribute.
     */
    public void setContentHandler(ContentHandler value) {
        contentHandler = value;
    }

    /**
     * @see javax.naming.Referenceable#getReference()
     */
    public Reference getReference() throws NamingException {

        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            try {
                oos.writeObject(contentHandler);
            }
            finally {
                oos.close();
            }
        }
        catch (IOException e) {
            Object[] params = new Object[] { e.getLocalizedMessage()};
            ResourceBundle rb = ResourceBundle.getBundle(EventMessages.class.getName());
			String msgTemplate = rb.getString(EventMessages.LOG_FAILED_TO_SERIALIZE_CONTENT_HANDLER_EXC_);
            String msg = MessageFormat.format(msgTemplate, params);
            throw new NamingException(msg);
        }
        byte[] stream = bos.toByteArray();
        BinaryRefAddr refAddr = new BinaryRefAddr(CBE_INSTANCE_ADDRESS, stream);
        Reference result = new Reference(EventFactoryImpl.class.getName(), refAddr, EventFactoryObjectFactory.class.getName(), null); // factory location

        return result;
    }

    /**
     * Accessor method to retrieve the instance of the singleton factory.
     * 
     * @return EventFactory
     */
    public static EventFactory getInstance() {
        return EventFactory.eINSTANCE;
    }
} //EventFactoryImpl
