/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.junit;

import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.ui.extension.ITypeValidator;

/**
 * Implementation of the ITypeValidator that accepts HTTP test suite types.
 * 
 */
public class TypeValidator
implements ITypeValidator
{
	/**
	 * @see org.eclipse.hyades.ui.extension.ITypeValidator#isValidType(java.lang.String)
	 */
	public boolean isValidType(String type)
	{
		if(TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;

		if(TestCommon.HTTP_JUNIT_TEST_CASE_TYPE.equals(type))
			return true;

		if(TestCommon.JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;

		if(TestCommon.JUNIT_TEST_CASE_TYPE.equals(type))
			return true;
			
		return false;
	}
}
