/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.context.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.logging.adapter.model.internal.context.Context;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Context</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public class ContextImpl extends ContextTypeImpl implements Context {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContextImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return ContextPackage.eINSTANCE.getContext();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ContextPackage.CONTEXT__COMPONENT:
					return ((InternalEList)getComponent()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ContextPackage.CONTEXT__DESCRIPTION:
				return getDescription();
			case ContextPackage.CONTEXT__EXECUTABLE_CLASS:
				return getExecutableClass();
			case ContextPackage.CONTEXT__IMPLEMENTATION_CREATION_DATE:
				return getImplementationCreationDate();
			case ContextPackage.CONTEXT__IMPLEMENTATION_VERSION:
				return getImplementationVersion();
			case ContextPackage.CONTEXT__IMPLEMENTATION_VERSION_DESCRIPTION:
				return getImplementationVersionDescription();
			case ContextPackage.CONTEXT__LOGGING_LEVEL:
				return getLoggingLevel();
			case ContextPackage.CONTEXT__NAME:
				return getName();
			case ContextPackage.CONTEXT__ROLE:
				return getRole();
			case ContextPackage.CONTEXT__ROLE_CREATION_DATE:
				return getRoleCreationDate();
			case ContextPackage.CONTEXT__ROLE_VERSION:
				return getRoleVersion();
			case ContextPackage.CONTEXT__ROLE_VERSION_DESCRIPTION:
				return getRoleVersionDescription();
			case ContextPackage.CONTEXT__UNIQUE_ID:
				return getUniqueID();
			case ContextPackage.CONTEXT__COMPONENT:
				return getComponent();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ContextPackage.CONTEXT__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case ContextPackage.CONTEXT__EXECUTABLE_CLASS:
				setExecutableClass((String)newValue);
				return;
			case ContextPackage.CONTEXT__IMPLEMENTATION_CREATION_DATE:
				setImplementationCreationDate((String)newValue);
				return;
			case ContextPackage.CONTEXT__IMPLEMENTATION_VERSION:
				setImplementationVersion((String)newValue);
				return;
			case ContextPackage.CONTEXT__IMPLEMENTATION_VERSION_DESCRIPTION:
				setImplementationVersionDescription((String)newValue);
				return;
			case ContextPackage.CONTEXT__LOGGING_LEVEL:
				setLoggingLevel((String)newValue);
				return;
			case ContextPackage.CONTEXT__NAME:
				setName((String)newValue);
				return;
			case ContextPackage.CONTEXT__ROLE:
				setRole((RoleNames)newValue);
				return;
			case ContextPackage.CONTEXT__ROLE_CREATION_DATE:
				setRoleCreationDate((String)newValue);
				return;
			case ContextPackage.CONTEXT__ROLE_VERSION:
				setRoleVersion((String)newValue);
				return;
			case ContextPackage.CONTEXT__ROLE_VERSION_DESCRIPTION:
				setRoleVersionDescription((String)newValue);
				return;
			case ContextPackage.CONTEXT__UNIQUE_ID:
				setUniqueID((String)newValue);
				return;
			case ContextPackage.CONTEXT__COMPONENT:
				getComponent().clear();
				getComponent().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ContextPackage.CONTEXT__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__EXECUTABLE_CLASS:
				setExecutableClass(EXECUTABLE_CLASS_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__IMPLEMENTATION_CREATION_DATE:
				setImplementationCreationDate(IMPLEMENTATION_CREATION_DATE_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__IMPLEMENTATION_VERSION:
				setImplementationVersion(IMPLEMENTATION_VERSION_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__IMPLEMENTATION_VERSION_DESCRIPTION:
				setImplementationVersionDescription(IMPLEMENTATION_VERSION_DESCRIPTION_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__LOGGING_LEVEL:
				setLoggingLevel(LOGGING_LEVEL_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__ROLE:
				unsetRole();
				return;
			case ContextPackage.CONTEXT__ROLE_CREATION_DATE:
				setRoleCreationDate(ROLE_CREATION_DATE_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__ROLE_VERSION:
				setRoleVersion(ROLE_VERSION_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__ROLE_VERSION_DESCRIPTION:
				setRoleVersionDescription(ROLE_VERSION_DESCRIPTION_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__UNIQUE_ID:
				setUniqueID(UNIQUE_ID_EDEFAULT);
				return;
			case ContextPackage.CONTEXT__COMPONENT:
				getComponent().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ContextPackage.CONTEXT__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case ContextPackage.CONTEXT__EXECUTABLE_CLASS:
				return EXECUTABLE_CLASS_EDEFAULT == null ? executableClass != null : !EXECUTABLE_CLASS_EDEFAULT.equals(executableClass);
			case ContextPackage.CONTEXT__IMPLEMENTATION_CREATION_DATE:
				return IMPLEMENTATION_CREATION_DATE_EDEFAULT == null ? implementationCreationDate != null : !IMPLEMENTATION_CREATION_DATE_EDEFAULT.equals(implementationCreationDate);
			case ContextPackage.CONTEXT__IMPLEMENTATION_VERSION:
				return IMPLEMENTATION_VERSION_EDEFAULT == null ? implementationVersion != null : !IMPLEMENTATION_VERSION_EDEFAULT.equals(implementationVersion);
			case ContextPackage.CONTEXT__IMPLEMENTATION_VERSION_DESCRIPTION:
				return IMPLEMENTATION_VERSION_DESCRIPTION_EDEFAULT == null ? implementationVersionDescription != null : !IMPLEMENTATION_VERSION_DESCRIPTION_EDEFAULT.equals(implementationVersionDescription);
			case ContextPackage.CONTEXT__LOGGING_LEVEL:
				return LOGGING_LEVEL_EDEFAULT == null ? loggingLevel != null : !LOGGING_LEVEL_EDEFAULT.equals(loggingLevel);
			case ContextPackage.CONTEXT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ContextPackage.CONTEXT__ROLE:
				return isSetRole();
			case ContextPackage.CONTEXT__ROLE_CREATION_DATE:
				return ROLE_CREATION_DATE_EDEFAULT == null ? roleCreationDate != null : !ROLE_CREATION_DATE_EDEFAULT.equals(roleCreationDate);
			case ContextPackage.CONTEXT__ROLE_VERSION:
				return ROLE_VERSION_EDEFAULT == null ? roleVersion != null : !ROLE_VERSION_EDEFAULT.equals(roleVersion);
			case ContextPackage.CONTEXT__ROLE_VERSION_DESCRIPTION:
				return ROLE_VERSION_DESCRIPTION_EDEFAULT == null ? roleVersionDescription != null : !ROLE_VERSION_DESCRIPTION_EDEFAULT.equals(roleVersionDescription);
			case ContextPackage.CONTEXT__UNIQUE_ID:
				return UNIQUE_ID_EDEFAULT == null ? uniqueID != null : !UNIQUE_ID_EDEFAULT.equals(uniqueID);
			case ContextPackage.CONTEXT__COMPONENT:
				return component != null && !component.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //ContextImpl
