/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.outputter.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class OutputterFactoryImpl extends EFactoryImpl implements OutputterFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterFactoryImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass)
	{
		switch (eClass.getClassifierID()) {
			case OutputterPackage.SINGLE_FILE_OUTPUTTER_TYPE: return createSingleFileOutputterType();
			case OutputterPackage.STANDARD_OUT_OUTPUTTER_TYPE: return createStandardOutOutputterType();
			case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE: return createLoggingAgentOutputterType();
			case OutputterPackage.NOTIFICATION_OUTPUTTER_TYPE: return createNotificationOutputterType();
			case OutputterPackage.OUTPUTTER_CONFIG_TYPE: return createOutputterConfigType();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case OutputterPackage.OUTPUTTER_TYPE:
				return OutputterType.get(initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case OutputterPackage.OUTPUTTER_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SingleFileOutputterType createSingleFileOutputterType() {
		SingleFileOutputterTypeImpl singleFileOutputterType = new SingleFileOutputterTypeImpl();
		return singleFileOutputterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StandardOutOutputterType createStandardOutOutputterType() {
		StandardOutOutputterTypeImpl standardOutOutputterType = new StandardOutOutputterTypeImpl();
		return standardOutOutputterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LoggingAgentOutputterType createLoggingAgentOutputterType() {
		LoggingAgentOutputterTypeImpl loggingAgentOutputterType = new LoggingAgentOutputterTypeImpl();
		return loggingAgentOutputterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationOutputterType createNotificationOutputterType() {
		NotificationOutputterTypeImpl notificationOutputterType = new NotificationOutputterTypeImpl();
		return notificationOutputterType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterConfigType createOutputterConfigType()
	{
		OutputterConfigTypeImpl outputterConfigType = new OutputterConfigTypeImpl();
		return outputterConfigType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterPackage getOutputterPackage()
	{
		return (OutputterPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static OutputterPackage getPackage()
	{
		return OutputterPackage.eINSTANCE;
	}

} //OutputterFactoryImpl
