/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.outputter.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.*;

import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage
 * @generated
 */
public class OutputterSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static OutputterPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterSwitch()
	{
		if (modelPackage == null) {
			modelPackage = OutputterPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject)
	{
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case OutputterPackage.SINGLE_FILE_OUTPUTTER_TYPE: {
					SingleFileOutputterType singleFileOutputterType = (SingleFileOutputterType)theEObject;
					Object result = caseSingleFileOutputterType(singleFileOutputterType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case OutputterPackage.STANDARD_OUT_OUTPUTTER_TYPE: {
					StandardOutOutputterType standardOutOutputterType = (StandardOutOutputterType)theEObject;
					Object result = caseStandardOutOutputterType(standardOutOutputterType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case OutputterPackage.LOGGING_AGENT_OUTPUTTER_TYPE: {
					LoggingAgentOutputterType loggingAgentOutputterType = (LoggingAgentOutputterType)theEObject;
					Object result = caseLoggingAgentOutputterType(loggingAgentOutputterType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case OutputterPackage.NOTIFICATION_OUTPUTTER_TYPE: {
					NotificationOutputterType notificationOutputterType = (NotificationOutputterType)theEObject;
					Object result = caseNotificationOutputterType(notificationOutputterType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case OutputterPackage.OUTPUTTER_CONFIG_TYPE: {
					OutputterConfigType outputterConfigType = (OutputterConfigType)theEObject;
					Object result = caseOutputterConfigType(outputterConfigType);
					if (result == null) result = caseProcessUnitType(outputterConfigType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Single File Outputter Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Single File Outputter Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSingleFileOutputterType(SingleFileOutputterType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Standard Out Outputter Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Standard Out Outputter Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseStandardOutOutputterType(StandardOutOutputterType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Logging Agent Outputter Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Logging Agent Outputter Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseLoggingAgentOutputterType(LoggingAgentOutputterType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Notification Outputter Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Notification Outputter Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseNotificationOutputterType(NotificationOutputterType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Config Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOutputterConfigType(OutputterConfigType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Process Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Process Unit Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseProcessUnitType(ProcessUnitType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object)
	{
		return null;
	}

} //OutputterSwitch
