/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.logging.adapter.model.internal.parser.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage
 * @generated
 */
public class ParserSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ParserPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParserSwitch()
	{
		if (modelPackage == null) {
			modelPackage = ParserPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject)
	{
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case ParserPackage.SUBSTITUTION_RULE_TYPE: {
					SubstitutionRuleType substitutionRuleType = (SubstitutionRuleType)theEObject;
					Object result = caseSubstitutionRuleType(substitutionRuleType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ParserPackage.RULE_ATTRIBUTE_TYPE: {
					RuleAttributeType ruleAttributeType = (RuleAttributeType)theEObject;
					Object result = caseRuleAttributeType(ruleAttributeType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ParserPackage.RULE_ELEMENT_TYPE: {
					RuleElementType ruleElementType = (RuleElementType)theEObject;
					Object result = caseRuleElementType(ruleElementType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ParserPackage.PARSER_CONFIG_TYPE: {
					ParserConfigType parserConfigType = (ParserConfigType)theEObject;
					Object result = caseParserConfigType(parserConfigType);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ParserPackage.RULE_ATTRIBUTE: {
					RuleAttribute ruleAttribute = (RuleAttribute)theEObject;
					Object result = caseRuleAttribute(ruleAttribute);
					if (result == null) result = caseRuleAttributeType(ruleAttribute);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case ParserPackage.RULE_ELEMENT: {
					RuleElement ruleElement = (RuleElement)theEObject;
					Object result = caseRuleElement(ruleElement);
					if (result == null) result = caseRuleElementType(ruleElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Substitution Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Substitution Rule Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSubstitutionRuleType(SubstitutionRuleType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Rule Attribute Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Rule Attribute Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRuleAttributeType(RuleAttributeType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Rule Element Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Rule Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRuleElementType(RuleElementType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Config Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseParserConfigType(ParserConfigType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Rule Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Rule Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRuleAttribute(RuleAttribute object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Rule Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Rule Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRuleElement(RuleElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object)
	{
		return null;
	}

} //ParserSwitch
