/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.sensor.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.AdapterCBESensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SingleFileSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.impl.ProcessUnitTypeImpl;
import org.eclipse.hyades.logging.adapter.model.internal.unit.util.Guid;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Config Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorConfigTypeImpl#getMaximumBlocking <em>Maximum Blocking</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorConfigTypeImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorConfigTypeImpl#getSingleFileSensor <em>Single File Sensor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorConfigTypeImpl#getAdapterCBESensor <em>Adapter CBE Sensor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorConfigTypeImpl#getStaticParserSensor <em>Static Parser Sensor</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SensorConfigTypeImpl extends ProcessUnitTypeImpl implements SensorConfigType {
	/**
	 * The default value of the '{@link #getMaximumBlocking() <em>Maximum Blocking</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaximumBlocking()
	 * @generated
	 * @ordered
	 */
	protected static final String MAXIMUM_BLOCKING_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMaximumBlocking() <em>Maximum Blocking</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaximumBlocking()
	 * @generated
	 * @ordered
	 */
	protected String maximumBlocking = MAXIMUM_BLOCKING_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final SensorType TYPE_EDEFAULT = SensorType.ADAPTER_CBE_SENSOR_LITERAL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected SensorType type = TYPE_EDEFAULT;

	/**
	 * This is true if the Type attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean typeESet = false;

	/**
	 * The cached value of the '{@link #getSingleFileSensor() <em>Single File Sensor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSingleFileSensor()
	 * @generated
	 * @ordered
	 */
	protected SingleFileSensorType singleFileSensor = null;

	/**
	 * The cached value of the '{@link #getAdapterCBESensor() <em>Adapter CBE Sensor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAdapterCBESensor()
	 * @generated
	 * @ordered
	 */
	protected AdapterCBESensorType adapterCBESensor = null;

	/**
	 * The cached value of the '{@link #getStaticParserSensor() <em>Static Parser Sensor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStaticParserSensor()
	 * @generated
	 * @ordered
	 */
	protected StaticParserSensorType staticParserSensor = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected SensorConfigTypeImpl() {
		super();
		uniqueID = (new Guid()).toString();		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass()
	{
		return SensorPackage.eINSTANCE.getSensorConfigType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMaximumBlocking()
	{
		return maximumBlocking;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaximumBlocking(String newMaximumBlocking)
	{
		String oldMaximumBlocking = maximumBlocking;
		maximumBlocking = newMaximumBlocking;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.SENSOR_CONFIG_TYPE__MAXIMUM_BLOCKING, oldMaximumBlocking, maximumBlocking));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(SensorType newType) {
		SensorType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		boolean oldTypeESet = typeESet;
		typeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.SENSOR_CONFIG_TYPE__TYPE, oldType, type, !oldTypeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetType() {
		SensorType oldType = type;
		boolean oldTypeESet = typeESet;
		type = TYPE_EDEFAULT;
		typeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, SensorPackage.SENSOR_CONFIG_TYPE__TYPE, oldType, TYPE_EDEFAULT, oldTypeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetType() {
		return typeESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SingleFileSensorType getSingleFileSensor() {
		return singleFileSensor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSingleFileSensor(SingleFileSensorType newSingleFileSensor, NotificationChain msgs) {
		SingleFileSensorType oldSingleFileSensor = singleFileSensor;
		singleFileSensor = newSingleFileSensor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR, oldSingleFileSensor, newSingleFileSensor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSingleFileSensor(SingleFileSensorType newSingleFileSensor) {
		if (newSingleFileSensor != singleFileSensor) {
			NotificationChain msgs = null;
			if (singleFileSensor != null)
				msgs = ((InternalEObject)singleFileSensor).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR, null, msgs);
			if (newSingleFileSensor != null)
				msgs = ((InternalEObject)newSingleFileSensor).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR, null, msgs);
			msgs = basicSetSingleFileSensor(newSingleFileSensor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR, newSingleFileSensor, newSingleFileSensor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AdapterCBESensorType getAdapterCBESensor() {
		return adapterCBESensor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAdapterCBESensor(AdapterCBESensorType newAdapterCBESensor, NotificationChain msgs) {
		AdapterCBESensorType oldAdapterCBESensor = adapterCBESensor;
		adapterCBESensor = newAdapterCBESensor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR, oldAdapterCBESensor, newAdapterCBESensor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAdapterCBESensor(AdapterCBESensorType newAdapterCBESensor) {
		if (newAdapterCBESensor != adapterCBESensor) {
			NotificationChain msgs = null;
			if (adapterCBESensor != null)
				msgs = ((InternalEObject)adapterCBESensor).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR, null, msgs);
			if (newAdapterCBESensor != null)
				msgs = ((InternalEObject)newAdapterCBESensor).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR, null, msgs);
			msgs = basicSetAdapterCBESensor(newAdapterCBESensor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR, newAdapterCBESensor, newAdapterCBESensor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StaticParserSensorType getStaticParserSensor() {
		return staticParserSensor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStaticParserSensor(StaticParserSensorType newStaticParserSensor, NotificationChain msgs) {
		StaticParserSensorType oldStaticParserSensor = staticParserSensor;
		staticParserSensor = newStaticParserSensor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR, oldStaticParserSensor, newStaticParserSensor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStaticParserSensor(StaticParserSensorType newStaticParserSensor) {
		if (newStaticParserSensor != staticParserSensor) {
			NotificationChain msgs = null;
			if (staticParserSensor != null)
				msgs = ((InternalEObject)staticParserSensor).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR, null, msgs);
			if (newStaticParserSensor != null)
				msgs = ((InternalEObject)newStaticParserSensor).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR, null, msgs);
			msgs = basicSetStaticParserSensor(newStaticParserSensor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR, newStaticParserSensor, newStaticParserSensor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
	{
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SensorPackage.SENSOR_CONFIG_TYPE__PROPERTY:
					return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
				case SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR:
					return basicSetSingleFileSensor(null, msgs);
				case SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR:
					return basicSetAdapterCBESensor(null, msgs);
				case SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR:
					return basicSetStaticParserSensor(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SensorPackage.SENSOR_CONFIG_TYPE__DESCRIPTION:
				return getDescription();
			case SensorPackage.SENSOR_CONFIG_TYPE__UNIQUE_ID:
				return getUniqueID();
			case SensorPackage.SENSOR_CONFIG_TYPE__PROPERTY:
				return getProperty();
			case SensorPackage.SENSOR_CONFIG_TYPE__MAXIMUM_BLOCKING:
				return getMaximumBlocking();
			case SensorPackage.SENSOR_CONFIG_TYPE__TYPE:
				return getType();
			case SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR:
				return getSingleFileSensor();
			case SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR:
				return getAdapterCBESensor();
			case SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR:
				return getStaticParserSensor();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SensorPackage.SENSOR_CONFIG_TYPE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__UNIQUE_ID:
				setUniqueID((String)newValue);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__PROPERTY:
				getProperty().clear();
				getProperty().addAll((Collection)newValue);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__MAXIMUM_BLOCKING:
				setMaximumBlocking((String)newValue);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__TYPE:
				setType((SensorType)newValue);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR:
				setSingleFileSensor((SingleFileSensorType)newValue);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR:
				setAdapterCBESensor((AdapterCBESensorType)newValue);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR:
				setStaticParserSensor((StaticParserSensorType)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SensorPackage.SENSOR_CONFIG_TYPE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__UNIQUE_ID:
				setUniqueID(UNIQUE_ID_EDEFAULT);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__PROPERTY:
				getProperty().clear();
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__MAXIMUM_BLOCKING:
				setMaximumBlocking(MAXIMUM_BLOCKING_EDEFAULT);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__TYPE:
				unsetType();
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR:
				setSingleFileSensor((SingleFileSensorType)null);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR:
				setAdapterCBESensor((AdapterCBESensorType)null);
				return;
			case SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR:
				setStaticParserSensor((StaticParserSensorType)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature)
	{
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SensorPackage.SENSOR_CONFIG_TYPE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case SensorPackage.SENSOR_CONFIG_TYPE__UNIQUE_ID:
				return UNIQUE_ID_EDEFAULT == null ? uniqueID != null : !UNIQUE_ID_EDEFAULT.equals(uniqueID);
			case SensorPackage.SENSOR_CONFIG_TYPE__PROPERTY:
				return property != null && !property.isEmpty();
			case SensorPackage.SENSOR_CONFIG_TYPE__MAXIMUM_BLOCKING:
				return MAXIMUM_BLOCKING_EDEFAULT == null ? maximumBlocking != null : !MAXIMUM_BLOCKING_EDEFAULT.equals(maximumBlocking);
			case SensorPackage.SENSOR_CONFIG_TYPE__TYPE:
				return isSetType();
			case SensorPackage.SENSOR_CONFIG_TYPE__SINGLE_FILE_SENSOR:
				return singleFileSensor != null;
			case SensorPackage.SENSOR_CONFIG_TYPE__ADAPTER_CBE_SENSOR:
				return adapterCBESensor != null;
			case SensorPackage.SENSOR_CONFIG_TYPE__STATIC_PARSER_SENSOR:
				return staticParserSensor != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString()
	{
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (maximumBlocking: ");
		result.append(maximumBlocking);
		result.append(", type: ");
		if (typeESet) result.append(type); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //SensorConfigTypeImpl
