/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.SearchFilterDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * @author sveyrier
 *
 */
public class OpenSDFilterDialog extends Action{
	
	private SDView view = null;
	
	public OpenSDFilterDialog(SDView theView)
	{
		super(SDViewerPlugin.getResourceString("POPUP_MENU_FILTER"));//$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("filter_obj.gif")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.sdFilter"); //$NON-NLS-1$
		view = theView;
	}

	public void run()
	{
		if (view == null)
			return;
		if ((view.getExtendedFindProvider()!=null)&&(view.getExtendedFilterProvider().getFilterAction()!=null))
		{
			view.getExtendedFilterProvider().getFilterAction().run();
		}
		else if (view.getSDFilterProvider()!=null)
		{
			SearchFilterDialog dialog = new SearchFilterDialog(view, view.getSDFilterProvider());
			dialog.open();
		}
	}
}
