/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.SearchFilterDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * @author sveyrier
 *
 */
public class OpenSDFindDialog extends Action{
	
	private SDView view = null;
	
	public OpenSDFindDialog(SDView theView)
	{
		super(SDViewerPlugin.getResourceString("POPUP_MENU_FIND"));//$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("search_seqdiag_co.gif")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.sdFind"); //$NON-NLS-1$
		view = theView;
	}

	public void run()
	{
		if (view == null)
			return;
		if ((view.getExtendedFindProvider()!=null)&&(view.getExtendedFindProvider().getFindAction()!=null))
		{
			view.getExtendedFindProvider().getFindAction().run();
		}
		else if (view.getSDFindProvider()!=null)
		{
			SearchFilterDialog dialog = new SearchFilterDialog(view, view.getSDFindProvider());
			dialog.open();
		}
	}
}
