/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.provider;


/**
 * Sequence Diagram loaders which implement this class provide the
 * actions for finding or filtering the sequence diagram.
 * This interface also allow the implemententor to set wich action/feature are supported
 * 
 * Action provider are associated to a Sequence Diagram SDWidget calling 
 * SDViewer.setSDFindProvider() or SDViewer.setSDFilterProvider
 * 
 * @author sveyrier
 *
 */
public abstract interface ISDGraphNodeSupporter {

	/**
	 * Return true to enable this options, false otherwise
	 * @return true to enable this options, false otherwise
	 */
	public boolean isLifelineSupported();
	
	/**
	 * Return true to enable this options, false otherwise
	 * @return true to enable this options, false otherwise
	 */
	public boolean isSyncMessageSupported();
	
	/**
	 * Return true to enable this options, false otherwise
	 * @return true to enable this options, false otherwise
	 */
	public boolean isSyncMessageReturnSupported();
	
	/**
	 * Return true to enable this options, false otherwise
	 * @return true to enable this options, false otherwise
	 */
	public boolean isAsyncMessageSupported();
	
	/**
	 * Return true to enable this options, false otherwise
	 * @return true to enable this options, false otherwise
	 */
	public boolean isAsyncMessageReturnSupported();
	
	/**
	 * Return true to enable this options, false otherwise
	 * @return true to enable this options, false otherwise
	 */
	public boolean isStopSupported();

}
