/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

/**
 * This class discribe the Find or Filter criteria selected by the user 
 * in the Find or Filter dialog box
 * @author sveyrier
 */
public class Criteria {
	

	protected boolean lifeLineSelected = false;
	protected boolean syncMessageSelected = false;
	protected boolean syncMessageReturnSelected = false;
	protected boolean asyncMessageSelected = false;
	protected boolean asyncMessageReturnSelected = false;
	protected boolean caseSenstiveSelected = false;
	protected boolean stopSelected;
	protected String expression = null;
	protected String[] StringList = null;
	
	/**
	 * Returns true if the AsyncMessageReturn is seclected, false otherwise
	 * @return true if the AsyncMessageReturn is seclected, false otherwise
	 */
	public boolean isAsyncMessageReturnSelected() {
		return asyncMessageReturnSelected;
	}

	/**
	 * Returns true if the AsyncMessage is seclected, false otherwise
	 * @return true if the AsyncMessage is seclected, false otherwise
	 */
	public boolean isAsyncMessageSelected() {
		return asyncMessageSelected;
	}
	
	/**
	 * Returns the text enter by the user
	 * @return the text
	 */
	public String getExpression() {
		return expression;
	}

	/**
	 * Returns true if the LifeLine is seclected, false otherwise
	 * @return true if the LifeLine is seclected, false otherwise
	 */
	public boolean isLifeLineSelected() {
		return lifeLineSelected;
	}

	/**
	 * Returns true if the Stop is seclected, false otherwise
	 * @return true if the Stop is seclected, false otherwise
	 */
	public boolean isStopSelected() {
		return stopSelected;
	}

	/**
	 * Returns true if the SyncMessageReturn is seclected, false otherwise
	 * @return true if the SyncMessageReturn is seclected, false otherwise
	 */
	public boolean isSyncMessageReturnSelected() {
		return syncMessageReturnSelected;
	}

	/**
	 * Returns true if the SyncMessage is seclected, false otherwise
	 * @return true if the SyncMessage is seclected, false otherwise
	 */
	public boolean isSyncMessageSelected() {
		return syncMessageSelected;
	}

	/**
	 * Set AsyncMessageReturn selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setAsyncMessageReturnSelected(boolean b) {
		asyncMessageReturnSelected = b;
	}

	/**
	 * Set AsyncMessage selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setAsyncMessageSelected(boolean b) {
		asyncMessageSelected = b;
	}

	/**
	 * Set the text enter by the user
	 * @param string the text
	 */
	public void setExpression(String string) {
		expression = string;
	}

	/**
	 * Set Stop selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setLifeLineSelected(boolean b) {
		lifeLineSelected = b;
	}

	/**
	 * Set Stop selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setStopSelected(boolean b) {
		stopSelected = b;
	}

	/**
	 * Set SyncMessageReturn selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setSyncMessageReturnSelected(boolean b) {
		syncMessageReturnSelected = b;
	}
	/**
	 * Set SyncMessage selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setSyncMessageSelected(boolean b) {
		syncMessageSelected = b;
	}

	/**
	 * Returns true if the case sentive is seclected, false otherwise
	 * @return true if the case sentive is seclected, false otherwise
	 */
	public boolean isCaseSenstiveSelected() {
		return caseSenstiveSelected;
	}

	/**
	 * Set case sentive selection state
	 * @param b true if selected, false otherwise 
	 */
	public void setCaseSenstiveSelected(boolean b) {
		caseSenstiveSelected = b;
	}

}
