/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.preferences;

import java.util.Iterator;
import java.util.Set;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.util.ContextIDs;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * The Sequence Diagram preferences page implementation
 * @author sveyrier
 */
public class SDViewerPage extends PreferencePage implements IWorkbenchPreferencePage,
							SelectionListener {
	
	/**
	 * The preference handler used to access the PreferenceStore
	 */
	private SDViewPref pref = null;
	/**
	 * BackGround color selector
	 */
	private ColorFieldEditor lineColor = null;
	/**
	 * Foreground color selector
	 */
	private ColorFieldEditor backGroundColor = null;
	
	/**
	 * List which display all modifiable sequence Diagram font
	 */
	private List classItemList  = null;
	
	/**
	 * Font selectr (The same is used for each modifiabmle font)
	 */
	private FontFieldEditor font = null;
	
	/**
	 * Link font when zoomin selector
	 */
	private BooleanFieldEditor link = null;
	
	/**
	 * Use gradient colorselector
	 */
	private BooleanFieldEditor useGrad = null;
	
	private Composite buttonArea;
	
	/**
	 * SwimLane width selector
	 */
	private IntegerFieldEditor lifelineWidth = null;
	
	
	public SDViewerPage() 
	{
		super();
	}
			
	/**
	 * Creates the Sequence Diagarm preference page content
	 * @param parent the parent composite
	 */
	protected Control createContents(Composite parent) 
	{
		parent.setLayout(new GridLayout ());
		Composite page  = new Composite (parent,SWT.NONE);
		WorkbenchHelp.setHelp(parent,SDViewerPlugin.getId()+ContextIDs.UML2SDPREF);
		GridLayout pageLayout = new GridLayout ();
		pageLayout.numColumns = 1;
		GridData pageLayoutdata = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_VERTICAL|
		GridData.VERTICAL_ALIGN_FILL);
		page.setLayoutData(pageLayoutdata);
		page.setLayout(pageLayout);
		
		//link font with zoom pref
		link = new BooleanFieldEditor(SDViewPref.PREF_LINK_FONT,
					SDViewerPlugin.getResourceString(SDViewPref.PREF_LINK_FONT), page);//
		link.setPreferenceStore(pref.getPreferenceStore());
		link.load();
		
		//use gradient color pref
		useGrad = new BooleanFieldEditor(SDViewPref.PREF_USE_GRADIENT,
					  SDViewerPlugin.getResourceString(SDViewPref.PREF_USE_GRADIENT), page);//
		useGrad.setPreferenceStore(pref.getPreferenceStore());
		useGrad.load();
		
		Label separator = new Label (page,SWT.SEPARATOR|SWT.HORIZONTAL|SWT.SHADOW_NONE);
		GridData sepData = new GridData(GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_HORIZONTAL|
						GridData.VERTICAL_ALIGN_FILL);
		separator.setLayoutData(sepData);
		
		Composite prefPage = new Composite(page,SWT.NONE);		
		GridLayout prefPageLayout = new GridLayout ();
		GridData prefPageLayoutdata = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_VERTICAL|
		GridData.VERTICAL_ALIGN_FILL);
		prefPage.setLayoutData(pageLayoutdata);
		prefPageLayout.numColumns = 1;
		prefPage.setLayout(prefPageLayout);
		
		//swimLane width pref
		lifelineWidth = new IntegerFieldEditor(SDViewPref.PREF_LIFELINE_WIDTH,
							SDViewerPlugin.getResourceString(SDViewPref.PREF_LIFELINE_WIDTH), prefPage);
		lifelineWidth.setPreferenceStore(pref.getPreferenceStore());
		lifelineWidth.setValidRange(119,500);
		lifelineWidth.load();
			
		//not very nice		
		Label separator2 = new Label (prefPage,SWT.SEPARATOR|SWT.HORIZONTAL|SWT.SHADOW_NONE);
		Label separator3 = new Label (prefPage,SWT.SEPARATOR|SWT.HORIZONTAL|SWT.SHADOW_NONE);

		//Font list pref
		classItemList = new List (prefPage, SWT.SINGLE|SWT.H_SCROLL|SWT.V_SCROLL|SWT.BORDER);
		GridData tabItemLayoutdata = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_VERTICAL|
		GridData.VERTICAL_ALIGN_FILL);
		classItemList.setLayoutData(tabItemLayoutdata);	
		for (int i=0;i<SDViewPref.fontList.length;i++)
		{
			classItemList.add(SDViewerPlugin.getResourceString(SDViewPref.fontList[i]));
		}
		classItemList.setSelection(0);
		classItemList.addSelectionListener(this);
		buttonArea = new Composite (prefPage,SWT.NONE);
		GridData tabItemLayoutdata2 = new GridData(GridData.HORIZONTAL_ALIGN_FILL/*|GridData.GRAB_HORIZONTAL*/|GridData.GRAB_VERTICAL|
				GridData.VERTICAL_ALIGN_FILL);
		buttonArea.setLayoutData(tabItemLayoutdata2);
		GridLayout buttonAreaLayout = new GridLayout ();
		buttonAreaLayout.numColumns=1;
 		buttonArea.setLayout(buttonAreaLayout);
 		
 		//font selector initialise for the lifeline font pref
		font = new FontFieldEditor(SDViewPref.fontList[0],"",//$NON-NLS-1$
									SDViewerPlugin.getResourceString("PREF_FONT_PREVIEW_TEXT"), buttonArea); //$NON-NLS-1$
									font.getPreviewControl().setSize(500,500);
		font.setPreferenceStore(pref.getPreferenceStore());
		font.load();
		
		backGroundColor = new ColorFieldEditor(SDViewPref.fontList[0]+SDViewPref.BACK_COLOR_POSTFIX,
						SDViewerPlugin.getResourceString("PREF_BACK_COLOR"), buttonArea);//$NON-NLS-1$
		backGroundColor.setPreferenceStore(pref.getPreferenceStore());
		backGroundColor.load();
		
		lineColor = new ColorFieldEditor(SDViewPref.fontList[0]+SDViewPref.FORE_COLOR_POSTFIX,
					SDViewerPlugin.getResourceString("PREF_FORE_COLOR"), buttonArea);//$NON-NLS-1$
		lineColor.setPreferenceStore(pref.getPreferenceStore());
		lineColor.load();

		return page;
	}

	public void init(IWorkbench workbench) 
	{
		pref = SDViewPref.getInstance();
	}
	
	/**
	 * Apply the modification performed in the Sequence diagram
	 * prefrence page
	 */
	protected void performApply()
	{
		//Store the prefrences in the PreferenceStore
		if (!lifelineWidth.isValid())
		{
			lifelineWidth.showErrorMessage();
			return;
		}
		font.store();	
		backGroundColor.store();
		lineColor.store();
		link.store();
		useGrad.store();
		lifelineWidth.store();
		//then save them in the preference file
		pref.apply();
	}

	/**
	 * Apply the modification performed in the Sequence diagram
	 * prefrence page
	 * @return true
	 */
	public boolean performOk()
	{
		performApply();
		return true;
	}
	
	/**
	 * Loads the Sequence diagram default preference settings
	 */
	protected void performDefaults()
	{
		link.loadDefault();
		useGrad.loadDefault();
		lifelineWidth.loadDefault();
		
		//and all the fonts and colors
		//fonts and colors are stored for each time because
		//we are using only one FontFieldEditor
		Set keySet=SDViewPref.getInstance().fontPref.keySet();
		Iterator it = keySet.iterator();
		while (it.hasNext())
		{
			Object prefName = it.next();
			if (prefName instanceof String)
			{
				font.setPreferenceName((String)prefName);
				font.loadDefault();
				font.store();
			}
		}
		
		keySet = SDViewPref.getInstance().backColorPref.keySet();
		it = keySet.iterator();
		while (it.hasNext())
		{
			Object prefName = it.next();
			if (prefName instanceof String)
			{
				backGroundColor.setPreferenceName((String)prefName);
				backGroundColor.loadDefault();
				backGroundColor.store();
			}
			
		}
		
		keySet = SDViewPref.getInstance().foreColorPref.keySet();
		it = keySet.iterator();
		while (it.hasNext())
		{
			Object prefName = it.next();
			if (prefName instanceof String)
			{
				lineColor.setPreferenceName((String)prefName);
				lineColor.loadDefault();
				lineColor.store();
			}
		}
	}

	/**
	 * Sent when a new selection occurs in the graphNode font list
	 * @param e the selection event
	 */
	public void widgetSelected(SelectionEvent e)
	{
		//Store the past set font preference or else the
		//FontFieldEditor reassignment will make us loose the currrent modification
		font.store();
		lineColor.store();
		backGroundColor.store();
		
		//set the FontFieldEditor for the new selected graphNode font
		font.setPreferenceName(SDViewPref.fontList[classItemList.getSelectionIndex()]);
		font.load();
		
		backGroundColor.setPreferenceName(SDViewPref.fontList[classItemList.getSelectionIndex()]+
											SDViewPref.BACK_COLOR_POSTFIX);
		backGroundColor.load();
				
		lineColor.setPreferenceName(SDViewPref.fontList[classItemList.getSelectionIndex()]+
											SDViewPref.FORE_COLOR_POSTFIX);
		lineColor.load();
	
		//No Background for message graphNodes
		if ((SDViewPref.fontList[classItemList.getSelectionIndex()].equals(SDViewPref.PREF_SYNC_MESS))|| 
			(SDViewPref.fontList[classItemList.getSelectionIndex()].equals(SDViewPref.PREF_SYNC_MESS_RET))||
			(SDViewPref.fontList[classItemList.getSelectionIndex()].equals(SDViewPref.PREF_ASYNC_MESS))|| 
			(SDViewPref.fontList[classItemList.getSelectionIndex()].equals(SDViewPref.PREF_ASYNC_MESS_RET)))
			backGroundColor.setEnabled(false, buttonArea);
		else backGroundColor.setEnabled(true, buttonArea);
		
		if (SDViewPref.fontList[classItemList.getSelectionIndex()].equals(SDViewPref.PREF_FRAME))
			font.setEnabled(false, buttonArea);
		else font.setEnabled(true, buttonArea);
	}
	
	
	public void widgetDefaultSelected(SelectionEvent e)
	{
	}
}
