/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TRCContext implements IDisposable
{
	private RequestHelper	requestHelper;
	private List			resources;
	
	private IPath			testSuiteFolderPath;
	private String			testSuiteBaseName;
	private ITestSuite		currentTestSuite;
	
	private int				testCaseCounter;
	private ITestCase		currentTestCase;
	
	private ILoop			currentLoop;
	private ILoop			currentPage;
		
	// @TODO mdd new 
	public static final String GLOBAL_LASTRECV	= "__global";
	private LinkedList pageList;
	private int pageNumber;
	private HashMap	lastRecvHashMap = new HashMap();
	

	public TRCContext ()
	{
		requestHelper = new RequestHelper();
		pageList = new LinkedList();
		pageNumber = 0;
		lastRecvHashMap.put(GLOBAL_LASTRECV, new Integer(-1));
	}

	public RequestHelper getRequestHelper ()
	{
		return this.requestHelper;
	}
		
	public void setOutputFolder (IPath outputFolder)
	{
		this.testSuiteFolderPath = outputFolder;
	}
	
	public void setTestSuiteBaseName (String testSuiteBaseName)
	{
		this.testSuiteBaseName = testSuiteBaseName;
	}
	
	public ITestSuite newTestSuiteContext ()
	{
		currentTestSuite = createTestSuite();
		currentLoop = createLoop();
		currentTestSuite.getImplementor().getBlock().getActions().
			add(currentLoop);
		return currentTestSuite;
	}

	public ITestCase newTestCaseContext (String name)
	{
		currentTestCase = createTestCase(currentTestSuite, currentPage, name);
		requestHelper.setTestCase(currentTestCase);
		return currentTestCase;
	}
	
	public void finish ()
	{
		saveResources();
		dispose();
	}
		
	public void dispose ()
	{
		if(requestHelper != null)
			requestHelper.dispose();
		if(resources != null)
			resources.clear();	
	}
	
	private ITestSuite createTestSuite()
	{
		if(resources == null)
			resources = new ArrayList();
			
		IPath path = testSuiteFolderPath.append(testSuiteBaseName).
			addFileExtension(ICommonConstants.TEST_SUITE_FILE_EXTENSION);
		
		URI uri = URI.createPlatformResourceURI(path.toString());
		Resource resource = EMFUtil.getResourceFactory(ICommonConstants.
			TEST_SUITE_FILE_EXTENSION).createResource(uri);
		resources.add(resource);
		
		ITestSuite testSuite = HyadesFactory.INSTANCE.createTestSuite(resource);
		testSuite.setType(TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE);
		testSuite.setName(testSuiteBaseName);		
		if(testSuite.getImplementor() == null)
			HyadesFactory.INSTANCE.createImplementor(testSuite, false);
			
		String clsName = JavaUtil.getValidClassName(testSuite.getName(), true);
		if(clsName == null)
			clsName = "Test";
		testSuite.getImplementor().setResource("test." + clsName);

		return testSuite;
	}
	
	private ITestCase createTestCase(ITestSuite testSuite, ILoop loop,
		String testCaseBaseName)
	{
		String testCaseName = (++testCaseCounter) + " " + testCaseBaseName;
		ITestCase testCase = TestCommonUtil.createTestCase(testSuite,
			TestCommon.HTTP_JUNIT_TEST_CASE_TYPE, false, testCaseName);

		ITestInvocation testInvocation = HyadesFactory.INSTANCE.
			createTestInvocation(testCase);
		loop.getBlock().getActions().add(testInvocation);

		String baseName = TestJavaPlugin.getString("W_LWR_INV");
		String testName = testCase.getName();
		if(testName == null)
			testInvocation.setName(TestCommonUtil.getUniqueName(baseName,
				loop.getBlock().getActions()));
		else
			testInvocation.setName(TestCommonPlugin.getString("NME_CONCAT_SEP",
				new String[]{testName, baseName}));
		
		return testCase;
	}
	/** Create a default loop
	 * 
	 * @return ILoop
	 */
	private ILoop createLoop()
	{
		return createLoop(TestJavaPlugin.getString("W_LOOP") + " " + 1, 1);
	}
	
//	private ILoop createLoop()
//	{
//		ILoop loop = HyadesFactory.INSTANCE.createLoop();
//		loop.setName(TestJavaPlugin.getString("W_LOOP") + " " +
//			/* pageCount */ 1);
//		loop.getCondition().setConstraint("1");
//		return loop;
//	}
	
	private void saveResources()
	{
		for (Iterator i = resources.iterator(); i.hasNext();) {
			try {
				EMFUtil.save((Resource)i.next());
			}
			catch (Exception e) {
			}
		}
	}
	
	/**
	 * @return
	 */
	public LinkedList getPageList() {
		return pageList;
	}

	/**
	 * @param list
	 */
	public void setPageList(LinkedList list) {
		pageList = list;
	}
	public ILoop createNewPage(int i) {
		currentPage = createPage(i);
		currentLoop.getBlock().getActions().add(currentPage);
		return currentPage;
	}
	
	public ILoop createNewPage(String s)
	{
		currentPage = createPage(TestHttpPlugin.getString("Page") + " " + s);
		currentLoop.getBlock().getActions().add(currentPage);
		return currentPage;
		
	}
	private ILoop createLoop(String name, int constraint)
	{
		ILoop loop = HyadesFactory.INSTANCE.createLoop();
		loop.setName(name);
		loop.getCondition().setConstraint(Integer.toString(constraint));
		return loop;
	}
	private ILoop createPage(int n)
	{
		return createPage(TestHttpPlugin.getString("Page") + " " + Integer.toString(n));
	}

	private ILoop createPage(String s)
	{
		ILoop page =  createLoop(s, 1);
		IPropertyGroup props = page.getActionProperties();
		List propList = props.getProperties();
		//create new Page property
		IProperty prop = HyadesFactory.INSTANCE.createProperty();
		prop.setName("HTTPPAGE");
		prop.setValue("true");
		propList.add(prop);
		return page;
	}
	/**
	 * @return
	 */
	public int getPageNumber() {
		return pageNumber;
	}

	/**
	 * @param i
	 */
	public void setPageNumber(int i) {
		pageNumber = i;
	}

	/**
	 * @return
	 */
	public HashMap getLastRecvHashMap() {
		return lastRecvHashMap;
	}

	/**
	 * @param map
	 */
	public void setLastRecvHashMap(HashMap map) {
		lastRecvHashMap = map;
	}

}
