/**********************************************************************
Copyright (c) 2003 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/
/*
 * NONE OF THE QUOTED STRINGS IN THIS FILE ARE TO BE LOCALIZED
 * THEY ARE ALL FOR XML TAGS, DEBUGGING SUPPORT, THEY ARE NOT FOR USER INTERFACES
 */
 
/*
 * Created on Jun 21, 2003
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.execution.recorder.http.remote;

/**
 * @author morris
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

import java.io.IOException;


import org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgent;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;

/**
 * @author morris
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SSLProxyRecorder extends RecorderAgent
{
	static int iProxyRecorderPort = 0;
	static Proxy proxy = null;
	static final String ErrorStartingRecorder = HttpRecResourceBundle.getInstance().getString("RECORDER_ERROR_STARTING");
	static final String StartingRecorder = HttpRecResourceBundle.getInstance().getString("RECORDER_STARTING_SSLPROXYRECORDER");
	static final String ListeningToPort = HttpRecResourceBundle.getInstance().getString("RECORDER_LISTENING_TO_PORT");
		
	public static void main(String[] args)
	{		
		new SSLProxyRecorder().run();
		
	}

	public Thread run()
	{

		try
		{
			
			sendDebugMessageToDataProcessor(StartingRecorder);
			proxy = new Proxy(this);
			proxy.start();
			sendDebugMessageToDataProcessor(ListeningToPort + iProxyRecorderPort);
			
			
			
		}
		
		catch (Exception e){
			controller.reportException(ErrorStartingRecorder + e.getMessage(), e);
			System.err.println(e);
			System.exit(1);
		}
		
		setIsReady(true);
		return proxy;
	}
	
	
	static PacketWriter packetWriter = null;
		
	private String configuration;
	public static class Proxy extends Thread 
	{
		String host;
		RecorderAgent agent = null;
		
		public Proxy(RecorderAgent agent)
		{
			this.agent = agent;
			packetWriter = new PacketWriter(agent);
			packetWriter.writeRecorderStartInfo(iProxyRecorderPort);			
		}
		
		public void run() {
			//ServerSocket serversocket = null;
			PeekServerSocket serversocket = null;
			
			try{
			
				//serversocket = new ServerSocket(iProxyRecorderPort);
				serversocket = new PeekServerSocket(iProxyRecorderPort);
				serversocket.setSoTimeout(600000);
			}
			catch (IOException e){
					
			}
	
		while (true){
			ClientSideReader cli_reader;
			
			try{
				//Socket client = serversocket.accept();
				PeekSocket client = serversocket.acceptPeekSocket();
				cli_reader = new ClientSideReader(client, packetWriter);
				cli_reader.start();
			}
			catch (Exception e){
				packetWriter.writeRecorderMessage(2, "exception in socket accept: " + e);
				
			}
			

		}
		}
					
	}

	
	public boolean init(String configuration )
	{
		this.configuration = configuration;
		int iStartPos, iEndPos;
		int iPortPos = configuration.indexOf("port,");
		
		if (iPortPos >= 0){
			iStartPos = iPortPos + 5;
			iEndPos = configuration.indexOf(";", iStartPos);
				if (iEndPos >= 0){
					iProxyRecorderPort = Integer.parseInt(configuration.substring(iStartPos, iEndPos ));
			}
			else{
				iProxyRecorderPort = Integer.parseInt(configuration.substring(iStartPos));
			}
		}

		return true;
	}
	

	
	public boolean handleCommand(int commandID, String commandData)
	{
		switch(commandID)
		{
			case STOP_RECORDING:
				if (packetWriter != null)
					packetWriter.writeRecorderStopInfo();
				return true;
			default:
				return false;
		}
	}

}
