/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.*;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 * 
 */
public class CBESortUI extends LogAnalyzerUI {

	private DoubleCList _doubleList;
	private ArrayList _sourceList = new ArrayList();
	private ArrayList _targetList = new ArrayList();
	
	private ArrayList _pdSortData = new ArrayList();

	private Text _sortString;
	private Composite composite;	

	/**
	 */
	public CBESortUI() {
		super();
	}
	/**
	* Creates and returns the contents of the upper part 
	* of the dialog (above the button bar).
	*
	* Subclasses should overide.
	*
	* @param the parent composite to contain the dialog area
	* @return the dialog area control
	*/
	public Control createControl(Composite parent) {
	
		composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		GridData data = GridUtil.createFill();
		data.widthHint  = 370;
		
		composite.setLayoutData(data);

		Label description = new Label(composite, SWT.NONE);
		description.setLayoutData(GridUtil.createHorizontalFill());
		description.setText(LogUIPlugin.getResourceString("SORT_DIALOG_DESCR"));

		_doubleList =
			new DoubleCList(
				composite,
				SWT.NULL,
				"",
				LogUIPlugin.getResourceString("SORT_SOURCE_LIST_DESCR"),
				LogUIPlugin.getResourceString("SORT_TARGET_LIST_DESCR"));

		_sortString = new Text(composite, SWT.MULTI | SWT.WRAP | SWT.V_SCROLL );
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 3;
		data.heightHint = 30;
		_sortString.setLayoutData(data);
		_sortString.setEditable(false);
		_doubleList.addSelectionListener(this);

		return composite;
	}

	/**
	 * Notifies that the ok button of this dialog has been pressed.
	 * <p>
	 * The default implementation of this framework method sets
	 * this dialog's return code to <code>Window.OK</code>
	 * and closes the dialog. Subclasses may override.
	 * </p>
	 */
	public boolean storeValues(IPreferenceStore store) {
	
		applyValues(store);
		_doubleList.removeSelectionListener(this);
		
		return true;		

	}
	
 
	public void applyValues(IPreferenceStore store){

		_pdSortData.clear();
	
		Object[] source = _doubleList.getSourceItems().toArray();
		Object[] target = _doubleList.getTargetItems().toArray();
	
		for (int idx = 0; idx < source.length; idx++) {
			_pdSortData.add(new ColumnData(source[idx].toString(), false));
		}
	
		for (int kdx = 0; kdx < target.length; kdx++) {
			_pdSortData.add(new ColumnData(target[kdx].toString(), true));
		}
	
		ColumnData.setColumns(_pdSortData, LogUIConstants.PD_SORT_LOG_OPTIONS, store);

	}

	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:05:18 PM)
	 */
	protected void populateList() {

		_sourceList.clear();
		_targetList.clear();

		ColumnData sortItem = null;
		ColumnData data = null;

		for (int idx = 0; idx < _pdSortData.size(); idx++) {
			sortItem = (ColumnData) _pdSortData.get(idx);
	
			if (sortItem.visible()) {
				_targetList.add(sortItem.name());
			} else {
				_sourceList.add(sortItem.name());
			}
		}
	}

	public void widgetSelected(SelectionEvent e) {
		//super.widgetSelected(e);
		setSortString();
		notifyListeners(e);		
	}

	private void setSortString() {
		String sort = "";
		StringBuffer sortBuffer = new StringBuffer();
		Object[] target = _doubleList.getTargetItems().toArray();
		for (int idx = 0; idx < target.length; idx++) {
			sortBuffer.append(", ");
			sortBuffer.append(target[idx].toString());
		}
		
		String criteria = LogUIPlugin.getResourceString("STR_SORT_CRITERIA");
		if (sortBuffer.length()>0) {
			sortBuffer.insert(1, criteria);
			sortBuffer.insert(criteria.length()+1,"<");
			sortBuffer.append(">");
			sort = sortBuffer.substring(1);
		} else {
			sortBuffer.append(LogUIPlugin.getResourceString("STR_SORT_CRITERIA"));
			sortBuffer.append("<>");
			sort = sortBuffer.toString();
		}

		_sortString.setText(sort);
	}

	/*
	 */
	public void initializeValues(boolean defaultValue) {
		
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();

		String pdSort = defaultValue ? store.getDefaultString(LogUIConstants.PD_SORT_LOG_OPTIONS):store.getString(LogUIConstants.PD_SORT_LOG_OPTIONS);
		createColumnDataFromString(pdSort, _pdSortData);

		populateList();
		
		_doubleList.removeAll();
		_doubleList.initializeSourceList(_sourceList);
		_doubleList.initializeTargetList(_targetList);

		if(defaultValue){
			Event e = new Event();
			e.data = new Integer(RecordChangeEvent.SORT_COL_CHANGE);
			e.type = SWT.Selection;
			e.widget = composite;
			notifyListeners(new SelectionEvent(e));
			 			
		}

		setSortString();		
	}
	
	
	
	
}
