/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class FilterOptionsUI{

	Button showCorrelationButton;

	public Composite createControl(Composite parent)
	{
		Composite correlationOptions = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		correlationOptions.setLayout(layout);
		correlationOptions.setLayoutData(GridUtil.createHorizontalFill());
		showCorrelationButton = new Button(correlationOptions, SWT.CHECK);
		showCorrelationButton.setText(LogUIPlugin.getResourceString("SHOW_CORRELATION_ONLY"));
	
		return correlationOptions;
	}

		public Button getShowCorrelationButton() {
		return showCorrelationButton;
	}

	public void setShowCorrelationButton(Button button) {
		showCorrelationButton = button;
	}

	public void initializeValues(boolean defaultValue)
	{
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		boolean buttonValue = true;
		if (defaultValue) {
			buttonValue = store.getDefaultString(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY).equals("1");
		}
		else {
			buttonValue = store.getString(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY).equals("1");			
		}
		showCorrelationButton.setSelection(buttonValue);	
		
	}
	
	public boolean storeValues() {
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();	
		store.setValue(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY,showCorrelationButton.getSelection()?"1":"-1");
		return true;	
	}
}
