/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;

public class LogRecordSearch {

	private List cbeList;
	private Object start = null;
	private int startIndex = -1;
	private RecordFilterSearchUtil recordFilterSearch = null;

	public LogRecordSearch() {
		super();
		recordFilterSearch = new RecordFilterSearchUtil();
	}

	public void initialize(List cbeList, Object start){
		this.cbeList = cbeList;
		this.start = start;
	    startIndex = -1; 	
		startIndex = lookForStartNodeIndex(start);
	}	

	public Object search(ArrayList filterTableElements, int direction,Object lastSelection){
        if(direction>0){
        	return searchDown(filterTableElements,lastSelection);
        }
        else{
        	return searchUp(filterTableElements,lastSelection);
        }	                        
	}
	
	private int lookForStartNodeIndex(Object start){
		if (start==null) return 0; 

		for (int i=0;i<cbeList.size();i++)
		{
			if (cbeList.get(i) instanceof CBECommonBaseEvent
				&& start instanceof CBECommonBaseEvent
				&& ((CBECommonBaseEvent)cbeList.get(i)).getGlobalInstanceId().equals(((CBECommonBaseEvent)start).getGlobalInstanceId())
				) {
					return i;
				}
		}
		return 0;
	}

   private Object searchDown(ArrayList filterTableElements,Object lastSelection){
   		if (lastSelection==start) startIndex++;
   		for (int i=startIndex;i<cbeList.size();i++)
   		{
   			if (recordFilterSearch.isAdvFilterApply((EObject)(cbeList.get(i)),filterTableElements))
   				return cbeList.get(i);
   		}
   		return null;
   }

   private Object searchUp(ArrayList filterTableElements,Object lastSelection){
	if (lastSelection==start) startIndex--;
	for (int i=startIndex;i>=0;i--)
	{
		if (recordFilterSearch.isAdvFilterApply((EObject)cbeList.get(i),filterTableElements))
			return cbeList.get(i);
	}
	return null;
   }

}

