/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.internal.config.generator;

import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigUtility {
	private static String resourceLocation = "org.eclipse.hyades.internal.config.generator.SetConfig";
	private static String lineSeparator = System.getProperty("line.separator");
	protected static ResourceBundle resource = null;

	public static String getString(String property) {
		return getString(resourceLocation, property);
	}

	public static String getString(String res, String property) {
		try {
			resource = ResourceBundle.getBundle(res);
		}
		catch (MissingResourceException e) {
			Logger.err(e.getMessage());
		}

		if(resource != null) {
			return resource.getString(property);
		}
		else {
			return null;
		}
	}

	public static String printElement(Node node) {
		return print(node, 0, false);
	}

	public static String print(Node node) {
		return print(node, 0, true);
	}

	public static String print(Node node, int numTab, boolean deepPrint) {
		StringBuffer strbuf = new StringBuffer();

		// Element start
		strbuf.append(tabs(numTab) + "<" + node.getNodeName());

		// Attributes
		NamedNodeMap attrs = node.getAttributes();

		// Sub elements
		NodeList elems = node.getChildNodes();

		if(attrs != null) {
			for(int i = 0; i < attrs.getLength(); i++) {
				if(attrs.item(i) instanceof Attr) {
					strbuf.append(" ");
					strbuf.append(((Attr)attrs.item(i)).getName());
					strbuf.append("=\"");
					strbuf.append(((Attr)attrs.item(i)).getValue());
					strbuf.append("\"");
				}
			}
		}

		//
		// Close element start if no sub elements
		//
		if(!deepPrint || (elems == null) || (elems.getLength() == 0)) {
			strbuf.append("/>" + ConfigUtility.lineSeparator);
		}
		else {
			strbuf.append(">" + ConfigUtility.lineSeparator);
			for(int i = 0; i < elems.getLength(); i++) {
				strbuf.append(print(elems.item(i), numTab + 1, true));
			}
			strbuf.append(tabs(numTab) + "</" + node.getNodeName() + ">" + ConfigUtility.lineSeparator);
		}

		return strbuf.toString();
	}

	protected static String tabs(int length) {
		StringBuffer strbuf = new StringBuffer();
		for(int i = 0; i < length; i++) {
			strbuf.append("\t");
		}
		return strbuf.toString();
	}

	public static String removeTrailings(String in) {
		String out = null;
		if(in != null) {
			out = in.trim();
			while(out.endsWith(PlatformObject.sr)) {
				out = out.substring(0, out.length()-1);
			}
		}
		return out;
	}

	public static String arrayToString(String[] array) {
		StringBuffer str = null;

		if(array != null) {
			str = new StringBuffer();
			for(int i = 0; i < array.length; i++) {
				str.append(array[i]);
				if(i < array.length - 1) {
					str.append(',');
				}
			}
		}

		if(str == null) {
			return null;
		}
		else {
			return str.toString();
		}
	}

	public static String[] stringToArray(String str) {
		String[] array = null;

		if(str != null) {
			StringTokenizer strtok = new StringTokenizer(str, " ,");
			array = new String[strtok.countTokens()];

			int i = 0;
			while(strtok.hasMoreTokens()) {
				array[i++] = strtok.nextToken();
			}
		}

		return array;
	}

	public static String getJvmLib(String javaPath) throws IOException {
		String sr = PlatformObject.sr; // path separator
		String jvm = PlatformObject.jvmLib; // JVM library name
		String path;
		File f = null;

		//
		// Check "$javaPath/classic"
		//
		path = new String(javaPath + sr + "classic" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Check "$javaPath/../jre/bin/classic"
		//
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "classic" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Check "$javaPath/server"
		// - Sun JDK 1.4.2
		path = new String(javaPath + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Check "$javaPath/../jre/bin/server"
		// - Sun JDK 1.4.2
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 59518
		// Check "$javaPath/client"
		// - Sun JDK 1.4.2
		path = new String(javaPath + sr + "client" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Bug 59518
		// Check "$javaPath/../jre/bin/client"
		// - Sun JDK 1.4.2
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "bin" + sr + "client" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Sun JDK 1.4.2: Check "$javaPath/../lib/i386/server"
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "i386" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Sun JDK 1.4.2: Check "$javaPath/../jre/lib/i386/server"
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "i386" + sr + "server" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Sun JDK 1.4.2: Check "$javaPath/../lib/i386/client"
		path = new String(javaPath + sr + ".." + sr + "lib" + sr + "i386" + sr + "client" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		// Sun JDK 1.4.2: Check "$javaPath/../jre/lib/i386/client"
		path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "i386" + sr + "client" + sr + jvm);
		f = new File(path);
		if((f != null) && f.exists()) {
			return f.getCanonicalPath();
		}

		//
		// Platform specific JDK's
		//
		if(PlatformObject.name.equals("HP-UX")) {
			// HP-UX: Check "$javaPath/../lib/PA_RISC/classic"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "PA_RISC" + sr + "classic" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// HP-UX: Check "$javaPath/../jre/lib/PA_RISC/classic"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "PA_RISC" + sr + "classic" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// HP-UX: Check "$javaPath/../lib/PA_RISC/server"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "PA_RISC" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// HP-UX: Check "$javaPath/../jre/lib/PA_RISC/server"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "PA_RISC" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}
		}
		else if(PlatformObject.name.equals("SunOS")) {
			// SunSPARC: Check "$javaPath/../lib/sparc"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// SunSPARC: Check "$javaPath/../jre/lib/sparc"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// Sun JDK 1.4.2: Check "$javaPath/../lib/sparc/server"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// Sun JDK 1.4.2: Check "$javaPath/../jre/lib/sparc/server"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + "server" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// Sun JDK 1.4.2: Check "$javaPath/../lib/sparc/client"
			path = new String(javaPath + sr + ".." + sr + "lib" + sr + "sparc" + sr + "client" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}

			// Sun JDK 1.4.2: Check "$javaPath/../jre/lib/sparc/client"
			path = new String(javaPath + sr + ".." + sr + "jre" + sr + "lib" + sr + "sparc" + sr + "client" + sr + jvm);
			f = new File(path);
			if((f != null) && f.exists()) {
				return f.getCanonicalPath();
			}
		}

		return null;
	}
}
