/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl;
import org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRMessageImpl;
import org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFSUTImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class HyadesUtil {
	public static final HyadesUtil INSTANCE = new HyadesUtil();
	
	public void createSUTInstances(BVRInteractionImpl interaction, BVRInteractionFragmentImpl action)
	{
		TPFTestSuiteImpl testSuite = null;

		if(interaction == null || action == null)
		{
			return;
		}

		if(interaction.getBehavior().getTest() instanceof TPFTestCaseImpl)
		{
			testSuite = (TPFTestSuiteImpl)((TPFTestCaseImpl)(interaction.getBehavior().getTest())).getOwner();
		}
		if(interaction.getBehavior().getTest() instanceof TPFTestSuiteImpl)
		{
			testSuite = (TPFTestSuiteImpl)interaction.getBehavior().getTest();
		}
		if(testSuite != null)
		{
			List systemUnderTests = testSuite.getISystemsUnderTest();
			Iterator iter2 = systemUnderTests.iterator();
			while(iter2.hasNext())
			{
				TPFSUTImpl systemUnderTest = (TPFSUTImpl)iter2.next();
				List methods = systemUnderTest.getMethods();
				Iterator iter3 = methods.iterator();
				while(iter3.hasNext())
				{
					CFGOperationImpl method = (CFGOperationImpl)iter3.next();
					if(action.getMessages().size() > 0)
					{
						BVRMessageImpl message = (BVRMessageImpl)action.getMessages().get(0);
						if(method.getName().equals(message.getOperation().getName()))
						{
							BVRLifelineImpl sutLifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactoryImpl.eINSTANCE.createBVRLifeline();
							sutLifeline.setDescription("self lifeline for " + systemUnderTest.getName());
							sutLifeline.setName(systemUnderTest.getName() + "_selfLifeline");
							interaction.getLifelines().add(sutLifeline);
												
							CFGInstanceImpl instance = (CFGInstanceImpl) Common_ConfigurationFactoryImpl.eINSTANCE.createCFGInstance();
							instance.setName("instance for " + systemUnderTest.getName());
							instance.setClassType((CFGClass)systemUnderTest);
							instance.setLifeline(sutLifeline);	
							((CFGClassImpl)systemUnderTest).getInstances().add(instance);
						}
					}											
				}									
			}					
		}
	}
	
	public ITestSuite getTestSuite(ITest test)
	{
		if(test instanceof ITestCase)
		{
			test = ((ITestCase)test).getOwner();
		}
		else if (!(test instanceof ITestSuite))
		{
			test = null;
		}
		return (ITestSuite)test;		
	}

	public boolean containsSuite(List referencedSuites, ITestSuite test)
	{
		if(referencedSuites == null || test == null)
		{
			return false;
		}
		Iterator iter = referencedSuites.iterator();
		while(iter.hasNext())
		{
			if(((ITestSuite)iter.next()).getId().equals(test.getId()))
			{
				return true;
			}
		}
		return false;
	}
	

}
