/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;


public class XMLAssociationEngineLoader extends CBEBaseXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected CorrelationEngine rootElement;

    //~ Constructors -------------------------------------------------------------------------------

    public XMLAssociationEngineLoader() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        EStructuralFeature feature;

        feature = rootElement.eClass().getEStructuralFeature(name);

        if (feature != null) {
            if (feature instanceof EAttribute) {
                Object newValue = EcoreUtil.createFromString((EDataType) feature.getEType(), value);

                if (newValue != null) {
                    rootElement.eSet(feature, newValue);
                }

                return;
            } else if (feature instanceof EReference) {
                addForwardReference(rootElement, (EReference) feature, value);

                return;
            }
        }
    }

    public void addYourselfInContext() {
   
        rootElement.setCorrelationContainerProxy(LoadersUtils.getInternalCorrelationContainerProxy(context.getAgentProxy(),rootElement.getId()));
        
        processForwardReferences(rootElement.getId(),rootElement);
    }

    public void cleanUp() {
    	super.cleanUp();
        rootElement = null;
    }

    public void initialize(HierarchyContext context, String name) {
    	super.initialize(context,name);
        rootElement = HierarchyFactory.eINSTANCE.createCorrelationEngine();
        clear();
    }
}
