/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.EditorPlugin;

import java.util.*;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.*;

import org.eclipse.swt.layout.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

import org.eclipse.hyades.statistical.ui.variableloader.internal.*;

public class ControlTableEditor extends Composite implements DisposeListener
{
	public static final int VAL_CONTROL = 0;
	public static final int VAL_NAME = 1;
	public static final int VAL_DESC = 2;
	public static final int VAL_IMAGE = 3;
	public static final int VAL_SLIDER = 4;
	public static final int VAL_MODIFY = 5;
		
//	private Composite parent;
	private int style;
	private TableViewer tableViewer = null;
	private Vector datas = new Vector();
	private boolean editable = true;
//	private ResourceBundle resourceBundle;
	private Vector listeners = new Vector();
	
	private ComboBoxCellEditor comboBoxSliderCellEditor;

	private Integer[] sliderChoices = new Integer[] {
			new Integer(1),
		};
	private String[] sliderChoicesString = new String[] {
			"1",
		};

	public void addListener(ControlTableEditorListener newListener) {
		listeners.add(newListener);
	}

	public void notifyListeners(ZoomControlBar b) {
		for (int v = 0; v < listeners.size(); v++)
		{
			ControlTableEditorListener TCL = (ControlTableEditorListener) (listeners.elementAt(v));
			TCL.barEdited(b);
		}
	}

	public void setEditable(boolean newValue)
	{
		editable = newValue;
	}

//	public void setProtocolChoices(String[] newValues)
//	{
//		protocolChoices = (String[]) BaseSorter.StringSort(newValues, true, false);
//	}

	public void widgetDisposed(DisposeEvent e) {
		dispose();
	}

	public ControlTableEditor(Composite parent, int style, Object[][] values)
	{
		super(parent,style);
		
		parent.addDisposeListener(this);
		
//		this.parent = parent;
		this.style = style;
//		resourceBundle = ComptestResourceBundle.getInstance();

		for (int i = 0; i < datas.size(); i++) {
			try {
				BarElement ge = (BarElement)datas.get(i);
//				if (ge != null) ge.dispose();	
			} catch (Throwable e) {}
		}

		datas = new Vector();
//		datas.clear();
		for (int i = 0; i < values.length; i++)
			datas.add(new BarElement((ZoomControlBar)values[i][0], (String)values[i][1], (String)values[i][2], (Image)values[i][3], (Integer)values[i][4], (SDModifiableVariableRepresentation)values[i][5]));

		instantiate();
	}

	public void ensureControlsValid() {

		for (int i = 0; i < datas.size(); i++) {
			BarElement element = (BarElement)datas.get(i);

			if (element.slider.intValue() >= sliderChoices.length) {
				element.slider = new Integer(0);	
			}
		}
			
		if (tableViewer != null) tableViewer.refresh(true);
	}

	public void setSliderChoices(Integer[] values, String[] names) {
		sliderChoices = values;
		sliderChoicesString = names;

		comboBoxSliderCellEditor.setItems(names);

		ensureControlsValid();
		
		redraw();
	}
	
	public void setValues(Object[][] values)
	{

		for (int i = 0; i < datas.size(); i++) {
			try {
				BarElement ge = (BarElement)datas.get(i);
//				if (ge != null) ge.dispose();	
			} catch (Throwable e) {}
		}

		datas.clear();
		for (int i = 0; i < values.length; i++)
			datas.add(new BarElement((ZoomControlBar)values[i][0], (String)values[i][1], (String)values[i][2], (Image)values[i][3], (Integer)values[i][4], (SDModifiableVariableRepresentation)values[i][5]));

		System.err.println("GRAPH THINGY - SET VALUES");
		try {
		tableViewer.setInput(datas);
		} catch (Throwable t) {
			t.printStackTrace();	
		}
	}

	public Object[][] getValues()
	{
		Object[][] result = new Object[datas.size()][6];
		for (int v = 0; v < datas.size(); v++)
		{
			result[v][0] = ((BarElement) datas.get(v)).bar;
			result[v][1] = ((BarElement) datas.get(v)).name;
			result[v][2] = ((BarElement) datas.get(v)).description;
			result[v][3] = ((BarElement) datas.get(v)).image;
			result[v][4] = ((BarElement) datas.get(v)).slider;
			result[v][5] = ((BarElement) datas.get(v)).rep;
		}
		return result;
	}

//	public void setLayoutData(Object layoutData)
//	{
//		if (baseViewForm != null)
//			baseViewForm.setLayoutData(layoutData);

//		this.layoutData = layoutData;
//	}

	public void dispose() {
		super.dispose();
		
		disposables.addAll(datas);
		
		EditorPlugin.DBG.info(getClass()+":disposed");
		for (int i = 0; i < disposables.size(); i++) {
			try {
			Object o = disposables.get(i);
			if (o != null) {
				if (o instanceof Widget) {
					((Widget)o).dispose();	
				} else if (o instanceof Color) {
					((Color)o).dispose();	
				} else if (o instanceof Image) {
					((Image)o).dispose();	
				} else {
					try {
						EditorPlugin.disposeObject(o);
					} catch (Throwable e) {
						EditorPlugin.DBG.info("Class not found when disposing of "+o.getClass()+"/"+o+" ("+e+")");
					}
				}
			}
			} catch (Throwable e) {
				e.printStackTrace();
			}
		}		
	}

ArrayList disposables = new ArrayList();

	public void instantiate()
	{
		
		GridLayout glayout = new GridLayout(1,false);
		glayout.marginWidth = 0;
		glayout.marginHeight = 0;
		glayout.horizontalSpacing = 0;
		glayout.verticalSpacing = 0;
		
		setLayout(glayout);

//		baseViewForm = ComptestPlugin.getPlugin().getUIFactory().createBaseViewForm(parent, style);
//		baseViewForm.setBorderVisible(true);
//		baseViewForm.setTitle(resourceBundle.getString("label.Hosts"));
//		if (layoutData != null)
//			baseViewForm.setLayoutData(layoutData);
	
		GridData gdata = new GridData();
		gdata.horizontalAlignment = GridData.FILL;
		gdata.verticalAlignment = GridData.FILL;
		gdata.grabExcessHorizontalSpace = true;
		gdata.grabExcessVerticalSpace = true;
		
//		Table table = ComptestPlugin.getPlugin().getUIFactory().createBaseTable(baseViewForm, SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION);
//		Table table = new Table(this,SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION);
		Table table = new Table(this,SWT.FULL_SELECTION|SWT.HIDE_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(gdata);

		disposables.add(table);

		TableColumn tc = null;
		(tc = new TableColumn(table, SWT.LEFT)).setText(EditorPlugin.getString("TABLE_COLUMN_NAME"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.LEFT)).setText(EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.CENTER)).setText(EditorPlugin.getString("TABLE_COLUMN_IMAGE"));
		disposables.add(tc);
		(tc = new TableColumn(table, SWT.CENTER)).setText(EditorPlugin.getString("TABLE_COLUMN_SLIDER"));
		disposables.add(tc);

		comboBoxSliderCellEditor = new ComboBoxCellEditor(table, sliderChoicesString);


		CellEditor[] cellEditors = new CellEditor[4];
		cellEditors[0] = new TextCellEditor(table);
		cellEditors[1] = new TextCellEditor(table);
		cellEditors[2] = new TextCellEditor(table);
		cellEditors[3] = comboBoxSliderCellEditor;

		for (int i = 0; i < cellEditors.length; i++) {
			disposables.add(cellEditors[i]);
		}
		
		ICellEditorListener cellListener = new ICellEditorListener()
		{
			public void applyEditorValue()
			{
				tableViewer.getTable().setFocus();
			}

			public void cancelEditor()
			{
				tableViewer.getTable().setFocus();
			}

			public void editorValueChanged(boolean oldValidState, boolean newValidState)
			{
			}
		};

		for(int i = 0; i < cellEditors.length; i++) {
			cellEditors[i].addListener(cellListener);		
		}
			
		TableLayout tableLayout = new TableLayout();
		tableLayout.addColumnData(new ColumnWeightData(32, 50, true)); //name
		tableLayout.addColumnData(new ColumnWeightData(28, 50, true)); //description
		tableLayout.addColumnData(new ColumnWeightData(16, 30, true)); //image
		tableLayout.addColumnData(new ColumnWeightData(16, 30, true)); //slider
		table.setLayout(tableLayout);

		tableViewer = new TableViewer(table);
		tableViewer.setColumnProperties(new String[] {"name", "description", "image", "slider"}); //$NON-NLS-1$ //$NON-NLS-2$
		tableViewer.setContentProvider(new BarContentProvider());
		tableViewer.setLabelProvider(new BarLabelProvider());
		tableViewer.setCellEditors(cellEditors);

		tableViewer.setCellModifier(new BarCellModifier());
/*
		KeyListener keyListener = new KeyListener()
		{
			private Object lastElement;
			private int lastColumn;
			
			public void keyPressed(KeyEvent e)
			{
			}

			public void keyReleased(KeyEvent e)
			{
				if(e.character == ' ')
				{
					TableItem[] selections = tableViewer.getTable().getSelection();
					if(selections.length ==0)
						return;
						
					int columnCount = tableViewer.getTable().getColumnCount();
					Object element = tableViewer.getTable().getSelection()[0].getData();
					if(element == null)
						return;
						
					if(element.equals(lastElement))
					{
						lastColumn = (++lastColumn)%columnCount;
						if(lastColumn == 0)
							lastColumn=1;
					}
					else
					{
						lastElement = element;
						lastColumn = 1;
					}
					
					tableViewer.editElement(element, lastColumn);
				}	
			}
		};
		
		table.addKeyListener(keyListener);
*/
	}
	
	public class BarElement
	{
		public ZoomControlBar bar;
		public String name;
		public String description;
		public Integer slider;
		public Image image;
		public SDModifiableVariableRepresentation rep;
		
//		RGB black_rgb;

//		Image image;
//		GC image_gc;
//		Color bg_col, fg_col;

		public BarElement(ZoomControlBar bar, String name, String description, Image image, Integer slider, SDModifiableVariableRepresentation rep)
		{
			this.bar = bar;
			this.name = name;
			this.description = description;
			this.image = image;
			this.slider = slider;
			this.rep = rep;

//			black_rgb = new RGB(0,0,0);

//			PaletteData palettedat = new PaletteData(new RGB[]{color,color});

//			ImageData imgdat = new ImageData(9,9,1,palettedat);			
//			image = new Image(getDisplay(),imgdat);
			
//			redrawImage();
		}

		public void update() {

//			redrawImage();
		}
	}
	
	public class BarLabelProvider extends LabelProvider implements ITableLabelProvider
	{

		public Image getColumnImage(Object element, int columnIndex)
		{
			if (columnIndex == 2) {
				BarElement barElement = (BarElement) element;
				return  barElement.image;
			}
			
			return null;
			
//			Image columnImage = null;
//			BarElement graphElement = (BarElement) element;
//			switch (columnIndex)
//			{
//				case 2 :
//					columnImage = graphElement.image;
//					break;
//			}
			
//			return columnImage;
		}

		public String getColumnText(Object element, int columnIndex)
		{
			String columnText = "";
			BarElement barElement = (BarElement) element;
			switch (columnIndex)
			{
				case 0 :
					columnText = barElement.name;
					break;
				case 1 :
					columnText = barElement.description;
					break;
				case 2 :
					if (barElement.image == null) columnText = "none";
					break;
				case 3 :
					int index = barElement.slider.intValue();
					columnText = sliderChoicesString[index];
					break;
			}
			return columnText;
		}
	}

	public static class BarContentProvider implements IStructuredContentProvider
	{
		public Object[] getElements(Object input)
		{
			return ((Vector) input).toArray();
		}

		public void dispose()
		{
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
		{
		}
	}
	
	public class BarCellModifier implements ICellModifier
	{
		public boolean canModify(Object element, String property)
		{
			new Throwable("").printStackTrace();
			BarElement e = (BarElement) element;
			if("name".equals(property)) //$NON-NLS-1$
			{
				return false;
			}
			else if ("description".equals(property))
			{
				return false;
			}
			else if ("image".equals(property))
			{
				return false;
			}
			return true;
		}
		
		public Object getValue(Object element, String property)
		{
			BarElement e = (BarElement) element;
			if("name".equals(property)) //$NON-NLS-1$
			{
				return e.name;
			}
			else if ("description".equals(property))
			{
				return e.description;
			}
			else if ("image".equals(property))
			{
				return e.image;
			}
			else if ("slider".equals(property))
			{
				return e.slider;
			}
			else
			{
				return null;
			}
		}
		
		public void modify(Object element, String property, Object value)
		{
			Item item = (Item)element;
			BarElement e = (BarElement) item.getData();
			boolean changed = false;

			if("name".equals(property)) //$NON-NLS-1$
			{
			}
			else if("description".equals(property))
			{
			}
			else if("image".equals(property))
			{
			}
			else if("slider".equals(property)) //$NON-NLS-1$
			{
				Control control = comboBoxSliderCellEditor.getControl();
				if(control instanceof CCombo)
					value = new Integer(((CCombo)control).getSelectionIndex());
									
				int thisSelection = ((Integer) value).intValue();
				if(thisSelection > -1)
				{
					if(!sliderChoices[thisSelection].equals(e.slider))
					{
						changed = true;
						e.slider = sliderChoices[thisSelection];
					}
				}
			}
			if(changed)
			{
				notifyListeners(e.bar);
				tableViewer.refresh(e);
			}
		}
	}	
}