/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.core.resources.*;

/**
 * Allows a StatCon module to listen for file drops
 */
public interface StatConDropListener {
	/**
	 * Called when a file is dropped on StatCon with the registered file
	 * extension.
	 * @param statcon the StatCon interface associated with this drop
	 * @param path the path of the resource dropped on StatCon
	 * @return whether the drop was accepted
	 */
	public boolean drop(StatConInterface statcon, IResource path);
}