/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

/*
 * Created on 14-Nov-2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.statistical.ui.widgets.table.internal;

import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Text;

/**
 * @author george
 *
 * A listener to verify float values. 
 */

public class DoubleVerifyListener implements VerifyListener
{
	Text text_control;
	
	public DoubleVerifyListener(Text text_control)
	{
		this.text_control = text_control;		
	}
	
	// This code not currently used - should remove any starting zeros to give a decent 
	// representation of a float.
	// TODO Put it somewhere useful? - hmmm, but where?
	
	public String remove_starting_zeros(String text)
	{
		if (text.equals(""))
			return text;
					
		int i = 0;
		
		while (text.charAt(i) == '0' && i < text.length())
			i++;
		if ((i != 0) && (text.charAt(i) != '.') && (i != text.length()))
		{
			text = text.substring(0,i-1);			
		}
		return text;		
	}
		
	public void verifyText(VerifyEvent e)
	{
		if (e.text.length() == 0)
		{
			e.doit = true;
		}
		else
		{
			String text = text_control.getText();

			int first = text.indexOf('.');
			int last = text.lastIndexOf('.');
			
			int start = e.start;
			int end = e.end;
									
			String new_text = text.substring(0,start) + e.text + text.substring(end,text.length());
			if (new_text.equals("."))
			{
//				System.out.println(new_text);
				new_text = "0.";
				e.text = "0.";
//				System.out.println(new_text);								
			}			
			try
			{
				Double.parseDouble(new_text);
				e.doit = true;
			}
			catch (NumberFormatException ex)
			{
				e.doit = false;
			}
		}		
	}
}
