/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon;


import org.eclipse.hyades.internal.execution.local.common.*;

import org.eclipse.hyades.model.statistical.*;

import java.io.*;

public abstract class PerfmonLoader implements DataProcessor {

	public abstract void killProcess() throws Exception;
	
	public abstract void setFrequency(int freq) throws IOException;

	public abstract void setRemoteHost(String host) throws IOException;

	public abstract void getUpdatedTree() throws IOException;
	public abstract void getUpdatedTree(SDDescriptor descriptor) throws IOException;
	
	public abstract void counterON(SDDescriptor counter) throws IOException, NullPointerException;
	
	public abstract void counterOFF(SDDescriptor counter) throws IOException;

	public abstract SDDescriptor getModel();
	
	public abstract void addLoaderListener(StatisticalLoaderListener listener);

	public abstract void removeLoaderListener(StatisticalLoaderListener listener);

	public abstract void shutdown();

}
