/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon;

import java.util.Collection;
import java.util.*;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;

import org.eclipse.hyades.models.hierarchy.*;

import org.eclipse.hyades.loaders.util.*;

import org.eclipse.hyades.internal.execution.local.control.*;

import org.eclipse.jface.action.*;

import org.eclipse.ui.*;
import org.eclipse.swt.widgets.*;

public class ProfileNavigatorExtension implements org.eclipse.hyades.ui.extension.INavigatorContribution {

class ConfigurePerfmonAction extends Action {
	Agent agent;
	TRCAgent trcagent;
	public ConfigurePerfmonAction(TRCAgent trcagent, Agent agent) {
		super(PerfmonPlugin.getString("CONFIGURE_PERFMON"),PerfmonPlugin.img.getImageDescriptor(ImageManager.IMG_PERFMON_LOGO));
		this.agent = agent;
		this.trcagent = trcagent;
	}
	public void run() {
		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
		PerfmonCounterDialog dialog = new PerfmonCounterDialog(shell,trcagent,agent);
		
		dialog.open();
		
	}
}

	public void dispose() {
		//
	}

	public void fillContextMenu(IMenuManager menu, IStructuredSelection selections) {
		if (selections.size() > 1) return;
		if (selections.size() == 0) return;
		Object selection = selections.getFirstElement();
		if (selection instanceof TRCAgentProxy) {
			TRCAgentProxy aproxy = (TRCAgentProxy)selection;
//			TRCAgent agent = aproxy.getAgent();
//			PerfmonPlugin.DBG.info("SELECTED AGENT = "+agent);
//			agent.getProcess()

			Object obj = LoadersUtils.locateAgentInstance(aproxy);

			if (obj instanceof Agent) {
			
				Agent agent = (Agent)obj;
	
				if (agent != null) {
					if (agent.getType().equals("PerfmonAgent")) {
						menu.add(new ConfigurePerfmonAction(aproxy.getAgent(),agent));
					}
				}
			
			}
			
			//need to somehow get a reference to the RAC node here (...execution.local.control)
			//richard - walk up the tree and get the session == connection?			
		}
	}
	
	public java.util.List getChildren(Object item) {
		return new ArrayList();
	}
	
	public Collection getModifiedItems() {
		return new ArrayList();
	}
	
	public boolean hasChildren(Object item) {
		return false;
	}

}