/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Correlation Source Info</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Describes the known information from the received event.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getOwner <em>Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getReference <em>Reference</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getTargetInfo <em>Target Info</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationSourceInfo()
 * @model 
 * @generated
 */
public interface CorrelationSourceInfo extends EObject{
	/**
	 * Returns the value of the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Owner</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Owner</em>' reference.
	 * @see #setOwner(EObject)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationSourceInfo_Owner()
	 * @model 
	 * @generated
	 */
	EObject getOwner();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getOwner <em>Owner</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Owner</em>' reference.
	 * @see #getOwner()
	 * @generated
	 */
	void setOwner(EObject value);

	/**
	 * Returns the value of the '<em><b>Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Reference</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Reference</em>' reference.
	 * @see #setReference(EReference)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationSourceInfo_Reference()
	 * @model 
	 * @generated
	 */
	EReference getReference();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getReference <em>Reference</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reference</em>' reference.
	 * @see #getReference()
	 * @generated
	 */
	void setReference(EReference value);

	/**
	 * Returns the value of the '<em><b>Target Info</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getSourceInfos <em>Source Infos</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target Info</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Target Info</em>' container reference.
	 * @see #setTargetInfo(UnresolvedCorrelation)
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#getCorrelationSourceInfo_TargetInfo()
	 * @see org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getSourceInfos
	 * @model opposite="sourceInfos" required="true"
	 * @generated
	 */
	UnresolvedCorrelation getTargetInfo();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getTargetInfo <em>Target Info</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target Info</em>' container reference.
	 * @see #getTargetInfo()
	 * @generated
	 */
	void setTargetInfo(UnresolvedCorrelation value);

} // CorrelationSourceInfo
