/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Correlation Source Info</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl#getOwner <em>Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl#getReference <em>Reference</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl#getTargetInfo <em>Target Info</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CorrelationSourceInfoImpl extends EObjectImpl  implements CorrelationSourceInfo {
	/**
	 * The cached value of the '{@link #getOwner() <em>Owner</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwner()
	 * @generated
	 * @ordered
	 */
	protected EObject owner = null;

	/**
	 * The cached value of the '{@link #getReference() <em>Reference</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReference()
	 * @generated
	 * @ordered
	 */
	protected EReference reference = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorrelationSourceInfoImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return HierarchyPackage.eINSTANCE.getCorrelationSourceInfo();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject getOwner() {
		if (owner != null && owner.eIsProxy()) {
			EObject oldOwner = owner;
			owner = (EObject)eResolveProxy((InternalEObject)owner);
			if (owner != oldOwner) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER, oldOwner, owner));
			}
		}
		return owner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject basicGetOwner() {
		return owner;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwner(EObject newOwner) {
		EObject oldOwner = owner;
		owner = newOwner;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER, oldOwner, owner));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getReference() {
		if (reference != null && reference.eIsProxy()) {
			EReference oldReference = reference;
			reference = (EReference)eResolveProxy((InternalEObject)reference);
			if (reference != oldReference) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE, oldReference, reference));
			}
		}
		return reference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference basicGetReference() {
		return reference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReference(EReference newReference) {
		EReference oldReference = reference;
		reference = newReference;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE, oldReference, reference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnresolvedCorrelation getTargetInfo() {
		if (eContainerFeatureID != HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO) return null;
		return (UnresolvedCorrelation)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTargetInfo(UnresolvedCorrelation newTargetInfo) {
		if (newTargetInfo != eContainer || (eContainerFeatureID != HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO && newTargetInfo != null)) {
			if (EcoreUtil.isAncestor(this, newTargetInfo))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTargetInfo != null)
				msgs = ((InternalEObject)newTargetInfo).eInverseAdd(this, HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS, UnresolvedCorrelation.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newTargetInfo, HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO, newTargetInfo, newTargetInfo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
					return eBasicSetContainer(null, HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.UNRESOLVED_CORRELATION__SOURCE_INFOS, UnresolvedCorrelation.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER:
				if (resolve) return getOwner();
				return basicGetOwner();
			case HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE:
				if (resolve) return getReference();
				return basicGetReference();
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				return getTargetInfo();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER:
				setOwner((EObject)newValue);
				return;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE:
				setReference((EReference)newValue);
				return;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				setTargetInfo((UnresolvedCorrelation)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER:
				setOwner((EObject)null);
				return;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE:
				setReference((EReference)null);
				return;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				setTargetInfo((UnresolvedCorrelation)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.CORRELATION_SOURCE_INFO__OWNER:
				return owner != null;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__REFERENCE:
				return reference != null;
			case HierarchyPackage.CORRELATION_SOURCE_INFO__TARGET_INFO:
				return getTargetInfo() != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //CorrelationSourceInfoImpl
