/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.internal.execution.testgen.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.RunTestGenWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

/**
 * action for generating a test from the resource navigator or the package explorer
 * @author Ernest Jessee
 */
public class GenerateTestActionDelegate extends ActionDelegate implements IObjectActionDelegate
{

	
	
	private IFile selectedRecModelFile = null;

	/**
	* @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	*/
	public void setActivePart(IAction action, IWorkbenchPart targetPart)
	{
		
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action)
	{						
		RunTestGenWizard wiz = new RunTestGenWizard(selectedRecModelFile);
		wiz.init(TestgenPlugin.getDefault().getWorkbench(), getSelection());
		WizardDialog dlg = new WizardDialog(Display.getDefault().getActiveShell(),wiz);
		dlg.open();	
						
	}
	
	

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection)
	{

		IFile file = (IFile)((IStructuredSelection)selection).getFirstElement();
		selectedRecModelFile = file;
	}

	protected IStructuredSelection getSelection()
	{
		IWorkbenchWindow window= TestgenPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
		if (window != null) {
			ISelection selection= window.getSelectionService().getSelection();
			if (selection instanceof IStructuredSelection) {
				return (IStructuredSelection) selection;
			}
			
		}
		return null;	
	}
}
