/**********************************************************************
Copyright (c) 2003 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 * This interface is a simple abstraction for passing control events between
 * the workbench and the remote IExecutionComponents.
 */

public interface IControlMessage {
	
	public static final String START = "START";
	
	public static final String STOP = "STOP";
	
	/**
	 * @param data The string representing the control event of this message. 
	 */
	public void setMessageData(String data);
	
	/**
	 * @return The string representing the control event of this message.
	 */
	public String getMessageData();

}
