/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.manual.internal.editor;

import org.eclipse.hyades.test.common.internal.editor.BehaviorSection;
import org.eclipse.hyades.test.java.internal.junit.editor.JUnitBehaviorForm;
import org.eclipse.hyades.test.manual.TestManualPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class ManualBehaviorForm
extends JUnitBehaviorForm
{
	/**
	 * Constructor for ManualBehaviorForm
	 * @param manualEditorExtension
	 * @param widgetFactory
	 */
	public ManualBehaviorForm(ManualEditorExtension manualEditorExtension, WidgetFactory widgetFactory)
	{
		super(manualEditorExtension, widgetFactory);
		setHeadingText(TestManualPlugin.getString("W_TST_SUITE"));
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.BehaviorForm#createBehaviorSection()
	 */
	protected BehaviorSection createBehaviorSection()
	{
		return new ManualBehaviorSection(this);
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_NAMED_ELEMENT_CONTROL:
				break;
				
			case HELP_FORM_CONTROL:
				break;
				
			case HELP_SECTION_CONTROL:
				break;
		}
	}	
}
