package org.eclipse.hyades.logging.adapter.formatters;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.FormattingException;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;

/*******************************************************************************
 * Copyright (c) 2004 Hyades project. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Common
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

/**
 * Extension of the <code>ProcessUnit</code> class to permit processing of
 * Common Base Event XML fragments, as <code>MessageString</code>s.
 * <p>
 * This class will only accept arrays of Common Base Event XML fragments, as
 * <code>MessageString</code>s.
 * <p>
 * The <code>processEventItems()</code> API receives an parameter array of
 * Common Base Event XML fragments, as <code>MessageString</code> s and
 * returns an array of <code>CommonBaseEvent</code>s. Each
 * <code>CommonBaseEvent</code> is the de-serialized Common Base Event XML
 * fragment in the associated index of the parameter array of Common Base Event
 * XML fragments, as <code>MessageString</code>s.
 * <p>
 * 
 * @author Paul E Slauenwhite
 * @see org.eclipse.hyades.logging.adapter.impl.ProcessUnit
 */
public class SerializedCBEFormatter extends ProcessUnit implements IFormatter {

    /**
     * Factory for creating events.
     */
    private static EventFactory eventFactory = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.adapter.impl.EventProcessUnit");

    /**
     * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItems(java.lang.Object[])
     */
    public Object[] processEventItems(Object[] msgs) {

        if ((msgs instanceof MessageString[]) && (msgs.length > 0)) {

            CommonBaseEvent[] events = new CommonBaseEvent[msgs.length];

            for (int counter = 0; counter < msgs.length; counter++) {

                try {
                    events[counter] = EventFormatter.eventFromCanonicalXML(((MessageString) (msgs[counter])).getValue());                    
                } 
                catch (FormattingException f) {
                    //Ignore.
                }
            }

            return events;
        }

        return null;
    }

    /**
     * @see org.eclipse.hyades.logging.adapter.IProcessUnit#testProcessEventItems(java.lang.Object[])
     */
    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {

        if (msgs instanceof MessageString[]) { return (new CommonBaseEvent[] { eventFactory.createCommonBaseEvent()}); }

        throw new AdapterInvalidConfig("EventProcessUnit only accepts arrays of MessageStrings");
    }
}