/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
/*
 * Created on Nov 14, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.execution.recorder.http.remote;
import java.io.*;
import javax.net.ssl.*;
import java.security.KeyStore;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import java.util.*;

/**
 * @author mdunn
 *
 * This class does all the SSL connections 
 *  
 */
public class SSLCheckClass {
	String sslCipherSuite = "";
	String sslProtocol = "";
	SSLContext serverSideConnectionContext = null;
	String sslKeyFile = "C:\\testkeys";
	//SSLContext clientSideConnectionContext = null;
	
	public boolean makeSecureConnection() {
		boolean isSecure = false;
			
		if ((connectToSecureServer(csr.destServer, csr.serverPort)) == true){
			if ((createSSLSpyServerSocket()) == true) {
				checkRightSideContexts();
				
				csr.packetWriter.writeOpenSecureConnectionInfo(csr.bSecure, csr.iConnection, 
					csr.destServer, csr.serverPort, csr.client, csr.httpServer, spySocket, 
					sslServer, csr.sslCipherSuite, csr.sslProtocol);
			}
			try {
				csr.to_client= spySocket.getOutputStream();
				csr.from_client = spySocket.getInputStream();
						
				// these are the decrypted streams
				csr.to_server = sslServer.getOutputStream();
				csr.from_server = sslServer.getInputStream();
				csr.httpServer.close();
				csr.httpServer = sslServer;

				csr.bSecure = true;
				csr.serverReader = new ServerSideReader(csr.client,
													csr.httpServer,
													csr.from_server,
													csr.to_client,
													 csr.packetWriter,
													 //csr.iConnection,
													 csr.connectionNumber,
													 csr.bSecure,
													 spySocket.getReceiveBufferSize());
				csr.serverReader.start();
			} 
			catch (IOException e) {
				csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + e);
				csr.packetWriter.getAgentController().reportException(SpySocketException,e);
				return false;
			}
		}
		csr.bNoPrintToServer = true;
		//csr.bSecure = isSecure;
		//return isSecure;
		return csr.bSecure;
	}
	public boolean connectToSecureServer(String destStr, int port){
		SSLContext ctx = null;
		try{
		
			SSLSocketFactory ssf = null;
			//TODO  use createSocket method that uses socket as input 
			TrustManager[] myTM = new TrustManager [] {new RecorderX509TrustManager() };
			//SSLContext ctx = SSLContext.getInstance("SSL");
			ctx = SSLContext.getInstance("SSL");
			ctx.init(null, myTM, null);
			ssf = ctx.getSocketFactory();			
			//sslServer = (SSLSocket)sslFact.createSocket(httpServer,destServer, serverPort,true);
			sslServer = (SSLSocket)ssf.createSocket(destStr, port);
			// when startHandshake returns, an SSL connection is
			// satisfied and handshaking is done transparently to this code
			sslServer.startHandshake();
		}
		catch (Exception e){
			csr.packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + e);
			csr.packetWriter.getAgentController().reportException(ClientSideReaderException,e);
			return false;
		}
		serverSideConnectionContext = ctx;
		return true;
	}		
	
	SSLSocket sslServer = null;
	SSLSocket spySocket = null;
	ClientSideReader csr = null;
	SSLSocket HTTPServerSocket = null;
	
	// ClientSideReaderHTTP csrHTTP = null;
	static final String SpySocketException = HttpRecResourceBundle.getInstance().getString("RECORDER_SSL_SPYSOCKET_EXCEPTION");
	static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");

	// a call here means the client has issued a CONNECT statement to this proxy server
	// we will attempt to open a separate secure connection to the requested server on the
	// requested port
	public SSLCheckClass(ClientSideReader thisCSR, String testKeys) {
		super();
		this.sslKeyFile = testKeys;
		csr = thisCSR; 
		
	}

	/**
	 * @param thisCSR
	 * @deprecated
	 */
	public SSLCheckClass(ClientSideReader thisCSR)
	{
		this(thisCSR, "C:\\testkeys");
	}
	
	public boolean createSSLSpyServerSocket(){	
	
		SSLSocketFactory ssf = null;
		SSLContext ctx = null;
		try {
		// set up key manager to do server authentication
		
		KeyManagerFactory kmf;
		KeyStore ks;
		char[] passphrase = "passphrase".toCharArray();
		String vendor = System.getProperty("java.vm.vendor");
	
		if ((vendor.indexOf("Sun")) >= 0){
			// The following to use Sun JVM
			ctx = SSLContext.getInstance("TLS");
			kmf = KeyManagerFactory.getInstance("SunX509");
		}
		else{
			// or use the following for the IBM JVM
			ctx = SSLContext.getInstance("SSL");
			kmf = KeyManagerFactory.getInstance("IbmX509");
		}
		
		ks = KeyStore.getInstance("jks");

		// TODO Need better place for testkeys file
		if (sslKeyFile == null || sslKeyFile.length() == 0)
			sslKeyFile = "C:\\testkeys";
		ks.load(new FileInputStream(sslKeyFile), passphrase);
		kmf.init(ks, passphrase);
		ctx.init(kmf.getKeyManagers(), null, null);
		ssf = ctx.getSocketFactory();
		
		spySocket = (SSLSocket)ssf.createSocket(csr.client,
				 "localhost", csr.client.getLocalPort(), true);
		spySocket.setUseClientMode(false);
		}
		catch (Exception e) {
			csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + e);
			csr.packetWriter.getAgentController().reportException(SpySocketException,e);
			return false;
		}
		//clientSideConnectionContext = ctx;
		return true;
	}	
	public boolean makeSecureConnectionHTTP(String proxyConnectString,String proxyAddr,int proxyPort) {
		boolean isSecure = false;
		boolean isOK = false;
		if (proxyConnectString.length() > 0) {		
			// Send CONNECT string to HTTP Proxy Server
			isOK = sendConnectToProxyServer(proxyConnectString);
			if (!isOK) {
				return false;
			}
			
			// Now convert current httpServer Socket into SSL Socket 
			
			//if ((connectToSecureServer(csr.destServer, csr.serverPort)) == true){
			boolean conversionOK = false;
			conversionOK = convertHTTPServerConnectionToSSL(proxyAddr,proxyPort);
			if (conversionOK == true) {
				if ((createSSLSpyServerSocket()) == true)
					checkRightSideContexts();
					csr.packetWriter.writeOpenSecureConnectionInfo(csr.bSecure,csr.iConnection, 
							csr.destServer, csr.serverPort, csr.client,csr.httpServer, 
							spySocket, sslServer,csr.sslCipherSuite,csr.sslProtocol);
				try {
					csr.to_client= spySocket.getOutputStream();
					csr.from_client = spySocket.getInputStream();
					// csr.client=(SSLSocket)spySocket;
							
					// these are the decrypted streams
					// new thing below - mdd
					csr.httpServer = HTTPServerSocket;
					csr.to_server = HTTPServerSocket.getOutputStream();
					csr.from_server = HTTPServerSocket.getInputStream();
					csr.bSecure = true;
					csr.secureConnectionOK = true;
					csr.serverReader = new ServerSideReader(csr.client,
														csr.httpServer,
														csr.from_server,
														csr.to_client,
														 csr.packetWriter,
														 //csr.iConnection,
														 csr.connectionNumber,
														 csr.bSecure,
														 spySocket.getReceiveBufferSize());
					csr.serverReader.start();
				} 
				catch (IOException e) {
					csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + e);
					csr.packetWriter.getAgentController().reportException(SpySocketException,e);
					return false;
				}
			}
		}
		csr.bNoPrintToServer = true;
		return csr.bSecure;
	}
	
	boolean sendConnectToProxyServer(String thisConnectString){
		boolean isOK = false;
		if (thisConnectString.length() > 0) {		
				// Send CONNECT string to HTTP Proxy Server
				try {
			
					byte[] sendBuffer = new byte[csr.client.getReceiveBufferSize()];
					byte[] ackBuffer = new byte[csr.httpServer.getReceiveBufferSize()];
						
					sendBuffer = thisConnectString.getBytes();
					csr.to_server.write(sendBuffer, 0, sendBuffer.length);
					csr.to_server.flush();	
					int ackBytes_read = csr.from_server.read(ackBuffer);
					if (ackBytes_read > 0){
						// check for status
						String statusLine = new String(ackBuffer, 0, ackBytes_read); 
						int findOK = statusLine.indexOf(" 200 ");
						if (findOK >= 0) {
							// send OK to client
							csr.to_client.write(ackBuffer,0,ackBytes_read);
							csr.to_client.flush();
							isOK = true;
						}
						else{
							isOK = false;
						}
					}
				
				} catch (IOException e) {
					csr.packetWriter.writeRecorderMessage(2, "exception in makeSecureConnection(): " + e);
					csr.packetWriter.getAgentController().reportException(SpySocketException,e);
					return false;
				}
		}
		return isOK;
	}
	boolean convertHTTPServerConnectionToSSL(String proxyAddr, int proxyPort) {
		boolean convertOK = true;
		SSLSocketFactory ssf = null;
		SSLContext ctx;
	
		try {

			TrustManager[] myTM = new TrustManager [] {new RecorderX509TrustManager() };
			//SSLContext ctx = SSLContext.getInstance("SSL");
			ctx = SSLContext.getInstance("SSL");
			ctx.init(null, myTM, null);
			ssf = ctx.getSocketFactory();
			
			HTTPServerSocket = (SSLSocket)ssf.createSocket(csr.httpServer,
					csr.destServer, csr.serverPort,true);
	//				 proxyAddr, proxyPort, true);
			HTTPServerSocket.setUseClientMode(true);
			
			csr.httpServer = HTTPServerSocket;
			// Handshake begins automatically when data passed through socket
			//HTTPServerSocket.startHandshake();
		}
		catch (Exception e) {
			csr.packetWriter.writeRecorderMessage(2, "exception in creating HTTPServer Spy Socket: " + e);
			csr.packetWriter.getAgentController().reportException(SpySocketException,e);
			return false;
		}
		serverSideConnectionContext = ctx;
		return convertOK;
	}
	public void checkRightSideContexts() {
		byte [] serverID;
		byte [] clientID;
		//Vector allServerSessions = new Vector();
		Vector allClientSessions = new Vector();
		//Vector allServerCipherSuites = new Vector();
		//Vector allServerProtocols = new Vector();
		Vector allClientCipherSuites = new Vector();
		Vector allClientProtocols = new Vector();
		
		// first check ServerSide
		SSLSessionContext serverServerSessionContext = serverSideConnectionContext.getServerSessionContext();
		SSLSessionContext serverClientSessionContext = serverSideConnectionContext.getClientSessionContext();
		Enumeration serverE = serverServerSessionContext.getIds();
		Enumeration clientE = serverClientSessionContext.getIds();
		

		// Get all Sessions for ClientSideSessionContext
		for ( ; clientE.hasMoreElements(); ) {
			clientID = (byte [])clientE.nextElement();
			allClientSessions.add(serverClientSessionContext.getSession(clientID));
		}

		
		// Get all CipherSuites for ClientSideSessions
		int clientSessionsCount = allClientSessions.size();
		for (int i = 0; i < clientSessionsCount; i++){
			SSLSession tempSess = (SSLSession)allClientSessions.elementAt(i);
			allClientCipherSuites.add(tempSess.getCipherSuite());
			allClientProtocols.add(tempSess.getProtocol());
		}	

		for (int i = 0; i < clientSessionsCount; i++){
		//	String tmpProtStr = "Protocol for Client Session ";
		//	String tmpProtStr1 = " is : ";
		//	String tmpCipherStr = ", CipherSuite is: ";
			
			String tmpProtocol = (String)allClientProtocols.get(i);
			String tmpCipher = (String) allClientCipherSuites.get(i);
			if (i == 0) {
				csr.sslProtocol = tmpProtocol;
				csr.sslCipherSuite = tmpCipher;
				//csr.packetWriter.writeRecorderMessage(1, "In CheckRightSide, Assign cipherSuite: " + csr.sslCipherSuite + " Protocol: " + csr.sslProtocol);
			}
			
		//	csr.packetWriter.writeRecorderMessage(1, tmpProtStr + i + tmpProtStr1 + tmpProtocol + tmpCipherStr + tmpCipher);
		}
		// now set sslCipherSuite if not already set
		if ((csr.sslCipherSuite.length() > 0) && (csr.sslProtocol.length()) > 0) {
			//csr.packetWriter.writeRecorderMessage(1, "In CheckRightSide, ASSIGN NEW DEFAULTS cipherSuite: " + csr.sslCipherSuite + " Protocol: " + csr.sslProtocol);
			csr.defaultCipherSuite = csr.sslCipherSuite;
			csr.defaultProtocol = csr.sslProtocol;
		}
		else {
			csr.sslCipherSuite = csr.defaultCipherSuite;
			csr.sslProtocol = csr.defaultProtocol;
			//csr.packetWriter.writeRecorderMessage(1, "In CheckRightSide, USE DEFAULTS cipherSuite: " + csr.sslCipherSuite + " Protocol: " + csr.sslProtocol);
		}
	}
}
