/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.ArrayList;

import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;

/**
 * A place where go commands to the translation algorithm from model to UML2SD.
 */
public class TraceInteractionUpdate {

	private GraphNode visibleGraphNode;
	private GraphNode previousVisibleGraphNode;
	
	private boolean pageChanged;
	private boolean maxMessagesByPageChanged;
	
	private boolean internalMessageFilteringChanged;
	
	private boolean findRequired;
	private ArrayList findResults;
	private Criteria findCriteria;
	private int findStartingPage;

	private boolean filteringChanged;
	
	private boolean dateSelectionChanged;
	private double dateToShow;
	
	private boolean threadSelectionChanged;
	private ArrayList selectedThreadList;
	
	private boolean horizontalCollapsingChanged;
	private boolean verticalCollapsingChanged;
	
	public TraceInteractionUpdate() {
	}
	
	public TraceInteractionUpdate(TraceInteractionUpdate from) {
		setSelectedThreadList(from.getSelectedThreadList());
	}

	
	public boolean needsUpdate() {
		return pageChanged ||
			   internalMessageFilteringChanged ||
			   findRequired ||
			   filteringChanged ||
			   dateSelectionChanged ||
			   threadSelectionChanged ||
			   isHorizontalCollapsingChanged() ||
			   isVerticalCollapsingChanged();
	}

	public void setVisibleGraphNode(GraphNode visibleGraphNode_) {
		visibleGraphNode = visibleGraphNode_;
	}
	public GraphNode getVisibleGraphNode() {
		return visibleGraphNode;
	}

	public void setPreviousVisibleGraphNode(GraphNode visibleGraphNode_) {
		previousVisibleGraphNode = visibleGraphNode_;
	}
	public GraphNode getPreviousVisibleGraphNode() {
		return previousVisibleGraphNode;
	}

	public void setPageChanged(boolean pageChanged_) {
		pageChanged = pageChanged_;
	}
	public boolean isPageChanged() {
		return pageChanged;
	}
	
	public void setMaxMessagesByPageChanged(boolean maxMessagesByPageChanged_) {
		maxMessagesByPageChanged = maxMessagesByPageChanged_;
	}

	public boolean isMaxMessagesByPageChanged() {
		return maxMessagesByPageChanged;
	}

	public void setInternalMessageFilteringChanged(boolean internalMessageFilteringChanged_) {
		internalMessageFilteringChanged = internalMessageFilteringChanged_;
	}
	public boolean isInternalMessageFilteringChanged() {
		return internalMessageFilteringChanged;
	}

	public void setFindRequired(boolean findRequired_) {
		findRequired = findRequired_;
	}
	public boolean isFindRequired() {
		return findRequired;
	}
	public void addFindResult(GraphNode findResult) {
		if (findResults == null) {
			findResults = new ArrayList();
		}
		findResults.add(findResult);
	}
	public ArrayList getFindResults() {
		return findResults;
	}
	public void setFilteringChanged(boolean filteringChanged_) {
		filteringChanged = filteringChanged_;
	}
	public boolean isFilteringChanged() {
		return filteringChanged;
	}
	public void setFindCriteria(Criteria findCriteria_) {
		findCriteria = findCriteria_;
	}
	public Criteria getFindCriteria() {
		return findCriteria;
	}

	public void setFindStartingPage(int findStartingPage_) {
		findStartingPage = findStartingPage_;
	}

	public int getFindStartingPage() {
		return findStartingPage;
	}

	public void setDateSelectionChanged(boolean dateSelectionChanged_) {
		dateSelectionChanged = dateSelectionChanged_;
	}
	public boolean isDateSelectionChanged() {
		return dateSelectionChanged;
	}
	public void setDateToShow(double dateToShow_) {
		dateToShow = dateToShow_;
	}
	public double getDateToShow() {
		return dateToShow;
	}

	public void setThreadSelectionChanged(boolean threadSelectionChanged_) {
		threadSelectionChanged = threadSelectionChanged_;
	}
	public boolean isThreadSelectionChanged() {
		return threadSelectionChanged;
	}
	public void addSelectedThread(TRCThread selectedThread_) {
		if (selectedThreadList == null) {
			selectedThreadList = new ArrayList();
		}
		selectedThreadList.add(selectedThread_);
	}
	public void setSelectedThreadList(ArrayList selectedThreadList_) {
		selectedThreadList = selectedThreadList_;
	}
	public ArrayList getSelectedThreadList() {
		return selectedThreadList;
	}

	public void setHorizontalCollapsingChanged(boolean horizontalCollapsingChanged_) {
		horizontalCollapsingChanged = horizontalCollapsingChanged_;
	}
	public boolean isHorizontalCollapsingChanged() {
		return horizontalCollapsingChanged;
	}

	public void setVerticalCollapsingChanged(boolean verticalCollapsingChanged_) {
		verticalCollapsingChanged = verticalCollapsingChanged_;
	}
	public boolean isVerticalCollapsingChanged() {
		return verticalCollapsingChanged;
	}
}