/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.drawings.impl;

import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

/**
 * @author sveyrier
 *
 */
public class ColorImpl implements IColor{
	
	protected Color col = null;
	protected boolean manageColor = true;
	
	public ColorImpl (Display display,int r, int g, int b)
	{
		col = new Color(display,r,g,b);
	}
	
	private ColorImpl (Color color)
	{
		col = color;
		manageColor = false;
	}
	
	public static ColorImpl getSystemColor(int color)
	{
		return new ColorImpl(Display.getDefault().getSystemColor(color));
	}

	public Object getColor() {
		return col;
	}
	
	public void dispose()
	{
		if ((col!= null)&&(manageColor))
			col.dispose();
	}

}
