/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ztest;

import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Stop;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
/**
 * @author sveyrier
 *
 */
public class ProtoLauncher2 {

	public static void main(String[] args) 
	{
		final Display display = new Display ();
		final Shell shell = new Shell (display);
		shell.setLayout(new FillLayout());
		final SDWidget v = new SDWidget(shell, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		final Frame testFrame = new Frame();
		
		testFrame.setName("Sequence Diagram"); //$NON-NLS-1$
		 
		Lifeline lifeline=new Lifeline(); 
		lifeline.setName("LifeLine " + 0);//$NON-NLS-1$
		testFrame.addLifeLine(lifeline);
		lifeline=new Lifeline();
		lifeline.setName("LifeLine " + 1); //$NON-NLS-1$
		testFrame.addLifeLine(lifeline);
		int count=-1;
		for (int i=1;i<100000;i++)
		{

			SyncMessage m3 = new SyncMessage();
			m3.autoSetStartLifeline(testFrame.getLifeline(0));
			m3.autoSetEndLifeline(testFrame.getLifeline(1));
			m3.setName("Message "+i); //$NON-NLS-1$
			testFrame.addMessage(m3);
			
		
			SyncMessageReturn m = new SyncMessageReturn();
			m.autoSetStartLifeline(testFrame.getLifeline(1));
			m.autoSetEndLifeline(testFrame.getLifeline(0));
			testFrame.addMessage(m);
			m.setName("Message return "+i); //$NON-NLS-1$
			
			Stop s = new Stop();
			s.setEventOccurrence(testFrame.getLifeline(1).getNewEventOccurrence());
//			s.setLifeline(((Lifeline)testFrame.getLifelines().get(1)),true);
//			((Lifeline)testFrame.getLifelines().get(1)).addStop(s);
			testFrame.getLifeline(1).setStop(s);
			
			BasicExecutionOccurrence occ= new BasicExecutionOccurrence();
			occ.setStartOccurrence(testFrame.getSyncMessage(i-1).getEventOccurrence());
			occ.setEndOccurrence(testFrame.getSyncMessage(i-1).getEventOccurrence());
			testFrame.getLifeline(1).addExecution(occ);
		}
		
		
/*		SyncMessage m = new SyncMessage(testFrame);
		m.setEndLifeline((Lifeline)testFrame.getLifelines().get(1));
		m.setEventOcurrence(4);*/
//		testFrame.addMessage(m);
		
//		v.setFrame(testFrame);
		shell.setSize(800,800);
		shell.open ();
		while (!shell.isDisposed ()) 
		{
			if (!display.readAndDispatch ()) display.sleep ();
		}
		display.dispose ();
	}
}
