/**********************************************************************
 * Copyright (c) 2003-2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;
import org.eclipse.hyades.models.trace.*;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import java.util.ArrayList;
import java.util.HashMap;


/**
 * 
 * @author hind.hasnaoui@fr.ibm.com /
 *
 * This class compute the method coverage 
 * 
 */
public class CoverageAnalysis {

	private CoverageFolder root = null;
	private HashMap coveragesMap = null;
		
	/**
	 * @param object
	 */
	public CoverageAnalysis(EObject object) {
		//Filter the list of packages
		Object packs[] = PerftraceUtil.getAllPackages(object);
		EList listPack = new BasicEList();
		for (int i = 0; i < packs.length; i++) {
			if (!CoverageUtil.isFiltered((TRCPackage)packs[i])) {
				listPack.add(packs[i]);
			}
		}

		//Compute method coverage
		if (!listPack.isEmpty()) {
			root = compute(listPack, object);
		} else {
			root = null;
		}
	}

	/**
	 * @param parent
	 * @param obj
	 * @return  an existing or new CoverageLeaf to store coverage data for this EObject
	 */
	public CoverageLeaf FindCoverageLeaf(CoverageFolder parent, EObject obj) {
		if (coveragesMap == null) {
			coveragesMap = new HashMap();
		}
		TRCMethod m = (TRCMethod)obj;
		String fullSig = CoverageUtil.getFullSig(m);
		CoverageLeaf cl = (CoverageLeaf)coveragesMap.get(fullSig);
		if (cl == null) {
			cl = new CoverageLeaf(this, parent);
			coveragesMap.put(fullSig, cl);
			parent.getChilds().add(cl);
		}
		cl.addTraceObjects(obj);
		return cl;
	}
	
	/**
	 * @param parent
	 * @param obj
	 * @return an existing or new CoverageFolder to store coverage data for this EObject
	 */
	public CoverageFolder FindCoverageFolder(CoverageFolder parent, EObject obj) {
		if (coveragesMap == null) {
			coveragesMap = new HashMap();
		}
		String fullSig = null;
		if (obj instanceof TRCClass) {
			TRCClass c = (TRCClass)obj;
			fullSig = CoverageUtil.getFullSig(c);
		} else if (obj instanceof TRCPackage) {
			TRCPackage p = (TRCPackage)obj;
			fullSig = CoverageUtil.getFullSig(p);
		} else {
			fullSig = obj.toString();
		}
		CoverageFolder cf = (CoverageFolder)coveragesMap.get(fullSig);
		if (cf == null) {
			cf = new CoverageFolder(this, parent);
			coveragesMap.put(fullSig, cf);
			parent.getChilds().add(cf);
		}
		cf.addTraceObjects(obj);
		return cf;
	}
	
	/**
	 * This method compute the method coverage
	 * @param listPack: filtered packages list
	 * @return the coverage object
	 */
	protected CoverageFolder compute(EList listPack, EObject proc) {
		CoverageFolder cov = new CoverageFolder(this, null);
		cov.addTraceObjects(proc);
		cov.parse(listPack);
		cov.compute();
		return cov;
	}

	/**
	 * Compute the class level tree
	 * @return
	 */
	public Coverage getClassLevel() {
		// Root
		CoverageFolder classLevel = duplicate(root);

		ArrayList classList = new ArrayList();
		classList.clear();

		ArrayList packList = root.getChilds();

		for (int i = 0; i < packList.size(); i++) {
			Coverage covPack = (Coverage) packList.get(i);
			ArrayList list = covPack.getChilds();
			for (int j = 0; j < list.size(); j++) {
				classList.add(list.get(j));
			}

		}

		classLevel.setChilds(classList);

		return classLevel;
	}

	/**
	 * Compute the method level tree
	 * @return
	 */
	public Coverage getMethodLevel() {
		int i, j;
		ArrayList list = new ArrayList();
		;
		ArrayList classList = new ArrayList();
		ArrayList methodList = new ArrayList();
		ArrayList methodListF = new ArrayList();

		//	Root
		CoverageFolder methodLevel = duplicate(root);

		ArrayList packList = root.getChilds();

		for (i = 0; i < packList.size(); i++) {
			Coverage covPack = (Coverage) packList.get(i);
			list = covPack.getChilds();
			for (j = 0; j < list.size(); j++) {
				classList.add(list.get(j));
			}

		}

		for (i = 0; i < classList.size(); i++) {
			Coverage covClass = (Coverage) classList.get(i);
			list = covClass.getChilds();
			for (j = 0; j < list.size(); j++) {
				methodList.add(list.get(j));
			}

		}

		// filter sub classes
		for (i = 0; i < methodList.size(); i++) {
			Coverage covElement = (Coverage) methodList.get(i);
			// if sub class
			if ((covElement.getTraceObj()) instanceof TRCClass) {
				list = covElement.getChilds();
				for (j = 0; j < list.size(); j++) {
					methodListF.add(list.get(j));
				}

			} else
				methodListF.add(covElement);
		}

		methodLevel.setChilds(methodListF);

		return methodLevel;
	}

	/**
	 * Duplicate the coverage root object
	 * @param covArg
	 * @return
	 */
	protected CoverageFolder duplicate(CoverageFolder covArg) {
		CoverageFolder cov = new CoverageFolder(this, null, covArg);
		return cov;

	}

	/**
	 * @return the root folder (summary) that has been computed during construction
	 */
	public CoverageFolder getRoot() {
		return root;
	}

}