/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.launch.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

/**
 * Provides the available Deployments in the Workspace for a given Test Suite.
 * @author jcanches
 */
public class DeploymentProvider extends LabelProvider implements IStructuredContentProvider, IElementComparer {
	
	private class DeploymentsCache {
		private TPFDeployment[] deployments;
		private Object testElement;
		public DeploymentsCache(Object testElement) {
			if (testElement instanceof TPFTestSuite || testElement instanceof TPFTestComponent) {
				// Try a specialized provider for the type of testElement
				IDeploymentsProvider provider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(testElement);
				// The return value is never null
				this.deployments = provider.getDeployments(testElement);
			}
			this.testElement = testElement;
		}
		public TPFDeployment[] getDeployments() {
			return this.deployments;
		}
		public Object getTestElement() {
			return this.testElement;
		}
	}
	
	private DeploymentsCache cache = null;
	
	public TPFDeployment[] getDeployments(Object testElement) {
		if (this.cache == null || !cache.getTestElement().equals(testElement)) {
			this.cache = new DeploymentsCache(testElement);
		}
		return this.cache.getDeployments();
	}
	
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof TPFTestSuite ||
			inputElement instanceof TPFTestComponent) {
			return this.getDeployments(inputElement);
		}
		return new Object[0];
	}
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// NOP
	}
	
	public Image getImage(Object element) {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_DEPLOYMENT);
	}
	
	public String getText(Object element) {
		if (element instanceof TPFDeployment) {
			return ((TPFDeployment)element).getName();
		}
		return "<invalid deployment>";
	}

	/**
	 * Redefine the comparison for TPFDeployment objects so that elements
	 * from a different resource set but that have the same URI are reported
	 * as equal.
	 */
	public boolean equals(Object a, Object b) {
		if (a.equals(b)) {
			return true;
		}
		if (a instanceof EObject && b instanceof EObject) {
			EObject ao = (EObject)a;
			EObject bo = (EObject)b;
			Resource ar = ao.eResource();
			Resource br = bo.eResource();
			return ar != null
				&& br != null
				&& ar.getURI().equals(br.getURI())
				&& ar.getURIFragment(ao).equals(br.getURIFragment(bo));
		}
		return false;
	}

	public int hashCode(Object element) {
		return element.hashCode();
	}
	
}
