/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.preference;

import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TestPreferencePage extends PreferencePage
	implements IWorkbenchPreferencePage, ModifyListener
{
	private Button openEditorAfterCreationCheckBox;
	private Text saveManagerIntervalText;
	private Text localPort;	
	private Text defaultHostName;
	
	/**
	 * Constructor for PluginPreferencePage.
	 */
	public TestPreferencePage()
	{
		super();
		setPreferenceStore(TestUIPlugin.getInstance().getPreferenceStore());
		
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent)
	{
//		WorkbenchHelp.setHelp(parent, TestUIPlugin.getID() + ".ctst0010");
		
		Composite composite= new Composite(parent, SWT.NONE);	
		
		GridLayout layout= new GridLayout();
		layout.marginWidth= 0;
		layout.marginHeight= 10;	
		layout.numColumns= 1;
		layout.verticalSpacing = 20;		
		composite.setLayout(layout);

		openEditorAfterCreationCheckBox = new Button(composite, SWT.CHECK);
		openEditorAfterCreationCheckBox.setText(TestUIPlugin.getString("OPEN_EDITOR_PREF")); //$NON-NLS-1$
				
		Composite threeCol = new Composite(composite, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 3;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.makeColumnsEqualWidth = false;
		threeCol.setLayout(layout);
		threeCol.setLayoutData(GridDataUtil.createHorizontalFill());
		
		Label label = new Label(threeCol, SWT.NONE);
		label.setText(TestUIPlugin.getString("SAVE_INT_PREF")); //$NON-NLS-1$
		
		saveManagerIntervalText = new Text(threeCol, SWT.BORDER);
		saveManagerIntervalText.setLayoutData(GridDataUtil.createHorizontalFill());

		label = new Label(threeCol, SWT.NONE);
		label.setText(TestUIPlugin.getString("STR_MSEC")); //$NON-NLS-1$

		Composite twoCol = new Composite(composite, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.verticalSpacing = 5;		
		layout.makeColumnsEqualWidth = false;
		twoCol.setLayout(layout);
		twoCol.setLayoutData(GridDataUtil.createHorizontalFill());

		label = new Label(twoCol, SWT.NULL);
		label.setText(TestUIPlugin.getString("RAC_LOCALHOST_PORT_TEXT")); //$NON-NLS-1$
		localPort = new Text(twoCol, SWT.BORDER);
		localPort.setLayoutData(GridDataUtil.createHorizontalFill());
		localPort.addModifyListener(this);

		label = new Label(twoCol, SWT.NULL);
		label.setText(TestUIPlugin.getString("DEF_HOST_NME")); //$NON-NLS-1$
		defaultHostName = new Text(twoCol, SWT.BORDER);
		defaultHostName.setLayoutData(GridDataUtil.createHorizontalFill());
		defaultHostName.addModifyListener(this);		

        initializeValues();
        
		WorkbenchHelp.setHelp(parent, TestUIPlugin.getID() + ContextIds.TEST_PREF_CONT);										
		WorkbenchHelp.setHelp(defaultHostName, TestUIPlugin.getID() + ContextIds.TEST_PREF_HOST_CONT);										
		WorkbenchHelp.setHelp(localPort, TestUIPlugin.getID() + ContextIds.TEST_PREF_PORT_CONT);										
		WorkbenchHelp.setHelp(openEditorAfterCreationCheckBox, TestUIPlugin.getID() + ContextIds.TEST_PREF_EDIT_CONT);										
		WorkbenchHelp.setHelp(saveManagerIntervalText, TestUIPlugin.getID() + ContextIds.TEST_PREF_SAVE_CONT);										

		return composite;
	}

	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues()
	{
		IPreferenceStore store = getPreferenceStore();

		openEditorAfterCreationCheckBox.setSelection(store.getBoolean(TestUI.OPEN_EDITOR));
		saveManagerIntervalText.setText(String.valueOf(store.getLong(TestUI.SAVE_INTERVAL)));
		localPort.setText(store.getString(TestUI.LOCALHOST_PORT));
		defaultHostName.setText(store.getString(TestUI.DEFAULT_HOST_NAME));
	}

	/*
	 * @see PreferencePage#performDefaults()
	 */
	protected void performDefaults()
	{
		super.performDefaults();		
		initializeDefaults();

	}
	
	protected IPreferenceStore doGetPreferenceStore() {
		return TestUIPlugin.getInstance().getPreferenceStore();
	}
	
	
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults()
	{
		IPreferenceStore store = getPreferenceStore();

		openEditorAfterCreationCheckBox.setSelection(store.getDefaultBoolean(TestUI.OPEN_EDITOR));
		saveManagerIntervalText.setText(String.valueOf(store.getDefaultLong(TestUI.SAVE_INTERVAL)));
		localPort.setText(store.getDefaultString(TestUI.LOCALHOST_PORT));
		defaultHostName.setText(store.getDefaultString(TestUI.DEFAULT_HOST_NAME));
	}
	
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		TestUIPlugin.getInstance().savePluginPreferences();
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues()
	{
		IPreferenceStore store = getPreferenceStore();

		store.setValue(TestUI.OPEN_EDITOR, openEditorAfterCreationCheckBox.getSelection());
		try
		{
			store.setValue(TestUI.SAVE_INTERVAL, Long.parseLong(saveManagerIntervalText.getText().trim()));			
		}
		catch(Exception exc)
		{
		}
		
		store.setValue(TestUI.LOCALHOST_PORT, localPort.getText().trim());
		store.setValue(TestUI.DEFAULT_HOST_NAME, defaultHostName.getText().trim());
	}
	
	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}

    /**
     * 
     */
	public void modifyText(ModifyEvent e)
	{
		if (e.widget == localPort)
		{
			try
			{
				if (localPort.getText().trim() == "") //$NON-NLS-1$
				{
					setErrorMessage(TestUIPlugin.getString("_ERROR_RAC_EMPTY_PORT")); //$NON-NLS-1$
					return;
				}
			
				int value = Integer.parseInt(localPort.getText().trim());
				if (value<0)
				{
					setErrorMessage(TestUIPlugin.getString("_ERROR_RAC_INVALID_PORT")); //$NON-NLS-1$
					localPort.setFocus();
					return;
				}
				setErrorMessage(null);
			}
			catch (NumberFormatException nfe)
			{
					setErrorMessage(TestUIPlugin.getString("_ERROR_RAC_INVALID_PORT")); //$NON-NLS-1$
					localPort.setFocus();
			}
		}
	}

}
