/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher.defaults;


import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;


public class MemoryHeapUI{
	
	private Composite _detailsHeapGroup;
	private Button _showHeapInstance;
	
	private Label titleLabel;
	private Label optionsLabel;

	private boolean _enableHeap = false;	
	

	public MemoryHeapUI() {
		super();
	}

	public Composite createControl(Composite parent) {
		
		GridLayout layout;

		Composite result = new Composite(parent, SWT.NONE);

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 2;

		GridData data = GridUtil.createFill();
		result.setLayout(layout);
		result.setLayoutData(data);
		
		titleLabel = new Label(result, SWT.NULL);
		titleLabel.setText(UIPlugin.getResourceString("memoryType"));
		titleLabel.setLayoutData(GridUtil.createHorizontalFill());
		//white
		titleLabel.setBackground(new Color(null, 255, 255, 255));
		titleLabel.setFont(new Font(null, "Arial", 13, SWT.BOLD));

		new Label(result, SWT.NULL);

		optionsLabel = new Label(result, SWT.WRAP);
		optionsLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_HEAP"));
		data = new GridData();
		data.horizontalIndent = 20;
		data.widthHint = 375;
		optionsLabel.setLayoutData(data);


		Composite grp = new Composite(result, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		layout = new GridLayout();
		layout.numColumns = 1;
		grp.setLayout(layout);
		grp.setLayoutData(data);
		
		addHeapOption(grp);
		_detailsHeapGroup.setVisible(true);

		return result;
	}

	private void addHeapOption(Composite parent) {
		GridLayout layout;
		GridData data;

		//title -  Memory/Heap Analysis
		//	Options label
	
		
		_detailsHeapGroup = new Composite(parent, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 20;
		_detailsHeapGroup.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		_detailsHeapGroup.setLayout(layout);

		_showHeapInstance = new Button(_detailsHeapGroup, SWT.CHECK);
		_showHeapInstance.setText(
			UIPlugin.getResourceString("STR_SHOW_INST_LEVEL_INFO"));

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_showHeapInstance,
			UIPlugin.getPluginId() + ".topp0011");
	}

	public void enableButtons() {

		enableBtnGroup();
	}

	public void enableBtnGroup() {
		enableHeptBtnGroup();
	}

	private void enableHeptBtnGroup() {
		_showHeapInstance.setEnabled(true);
	}
	
	public void enableHeapInfo(boolean enable) {
		_enableHeap = enable;

		if (!enable) {
			_showHeapInstance.setEnabled(false);
		}
	}
	
	public boolean getHeapDetails() {
		return _showHeapInstance.getSelection();
	}

	public void setHeapDetails(boolean setValue) {
		_showHeapInstance.setSelection(setValue);
	}
}
