/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/ 

package org.eclipse.hyades.trace.ui.internal.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

/**
 * A profile detail item that appears under every TRCAgentProxy object in the
 * Profiling Monitor navigator if it has profiling details. 
 * The items will contain the same
 * content as their parent.
 */
public class ProfileDetailItem implements INavigatorItem {
	
	private static Image _image;
	private Object _parent;
	private String _name;
	private URL _url;
	
	public ProfileDetailItem(Object parent, String name, URL myURL) {
		_parent = parent;
		_name = name;
		_url = myURL;
	}

	/*
	 * The navigator looks for IAdaptables that have
	 * IWorkbenchAdapters. If present, they are used for
	 * content. 
	 */
	public Object getAdapter(Class adapter) {
		if (IWorkbenchAdapter.class.equals(adapter)) {
			return new WorkbenchAdapter() {
				public Object[] getChildren(Object object) {
					return ProfileDetailItem.this.getChildren().toArray();
				}
				public ImageDescriptor getImageDescriptor(Object object) {
					return ProfileDetailItem.this.getImageDescriptor();
				}
				public String getLabel(Object object) {
					return ProfileDetailItem.this.getText();
				}
				public Object getParent(Object object) {
					return ProfileDetailItem.this.getParent();
				}
			};
		}
		else {
			return null;
		}
	}
	
	// no children
	public List getChildren() {
		return new ArrayList();
	}
	
	// repeat the parent's data
	public Object getData() {
		return _parent;
	}
	
	public Image getImage() {
		if (_image == null) {
			_image = getImageDescriptor().createImage();
			Display.getDefault().addListener(SWT.Dispose, new Listener() {
				public void handleEvent(Event event) {
					_image.dispose();
				}
			});
		}
		return _image;
	}

	private ImageDescriptor getImageDescriptor() {
		return ImageDescriptor.createFromURL(_url);
	}
	
	public Object getParent() {
		return _parent;
	}

	// the text displayed in the label
	public String getText() {
		return _name;
	}
	
	public String getType() {
		if (_parent != null && _parent instanceof TRCAgentProxy) {
			TRCAgentProxy agent = (TRCAgentProxy)_parent;
			return agent.getType();
		}
		return null;
	}
	
	// no children
	public boolean hasChildren() {
		return false;
	}
	
	public boolean isDeleteEnabled() {
		return false;
	}
	
	// non-persistent; can't be saved
	public boolean isSaveEnabled() {
		return false;
	}
	
	public boolean isUnloadEnabled() {
		return false;
	}
	
	// not enabled
	public void delete(boolean referentialIntegrity, boolean deleteContents) {
	}

	// not enabled
	public void save(boolean referentialIntegrity) {
	}
	
	// not enabled
	public void unload(boolean referentialIntegrity) {
	}
}

