/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.local.common;

/**
 * @author Giridhar.S
 * 
 */
public class ManageFileCommand extends CommandElement implements Constants {

	public static final int GET 		= 0x01;
	public static final int PUT 		= 0x02;
	public static final int DELETE		= 0x03; 
	/**
	 * 
	 */
	protected long _operation;
	protected RAString _filename = new RAString("");;
	
	public ManageFileCommand() {
		super();
		_tag=RA_MANAGE_FILE;
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#getSize()
	 */
	public int getSize() {
		
		return 3*sizeofLong+_filename.getSize();
	}
	
	/**
	 * @return long - the operation
	 */
	public long getOperation()	{
		return _operation;
	}
	
	/**
	 * @return RAString - the file name
	 */
	public String getFilename()	{
		if (_filename != null)
			return _filename.getData();
		return null;
	}
	
	/**
	 * set the operation to be performed.
	 * @param operation
	 */
	public void setOperation(long operation)	{
		_operation=operation;
	}
	
	/**
	 * set file name to be passed to RAC
	 * @param filename
	 */
	public void setFilename(String filename)	{
		_filename= new RAString(filename);
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current=offset;
		_context=Message.readRALongFromBuffer(buffer, current);
		current+=sizeofLong;
		_operation=Message.readRALongFromBuffer(buffer, current);
		current+=sizeofLong;
		current=Message.readRAStringFromBuffer(buffer, current, _filename);
		return current;
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current=offset;
		current=Message.writeRALongToBuffer(buffer, current, _tag);
		current=Message.writeRALongToBuffer(buffer, current, _context);
		current=Message.writeRALongToBuffer(buffer, current, _operation);
		current=Message.writeRAStringToBuffer(buffer, current, _filename);
		return current;

	}
	
}