/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;


public class XMLfilterLoader extends IgnoredXMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    protected String genericPattern;
    protected String mode;
    protected String pattern;

    //~ Methods ------------------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
     */
    public void addAttribute(String name, String value) {
        if (name.equals("genericPattern")) {
            genericPattern = value;
        } else if (name.equals("mode")) {
            mode = value;
        } else if (name.equals("pattern")) {
            pattern = value;
        }
    }

    public void addYourselfInContext() {
        TRCAgent agent = context.getAgent();

        if (agent == null) {
            LoadersUtils.createAgent(context);
        }


        TRCAgentProxy agentProxy = context.getAgentProxy();

		if (agentProxy == null) {
			agentProxy = agent.getAgentProxy();
		}

        TRCConfiguration config = null;
        Object[] configList = agentProxy.getConfigurations().toArray();

        for (int idx = 0; idx < configList.length; idx++) {
            TRCConfiguration c = (TRCConfiguration) configList[idx];

            if ((c.getName() != null) && c.getName().equals("__JVMPI__")) {
                config = c;

                break;
            }
        }

        if (config == null) {
            config = HierarchyFactory.eINSTANCE.createTRCConfiguration();
            config.setName("__JVMPI__");
            config.setActive(true);
            config.setAgentProxy(agentProxy);
        }

        TRCFilter filter = HierarchyFactory.eINSTANCE.createTRCFilter();

        filter.setType(genericPattern);
        filter.setPattern(pattern);
        filter.setMode(mode);
        filter.setActive(Boolean.TRUE);
        filter.setConfiguration(config);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(java.lang.String)
     */
    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        pattern = null;
        genericPattern = null;
        mode = null;
    }
}
