/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ExtensionsPackageImpl extends EPackageImpl implements ExtensionsPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass queryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass simpleSearchQueryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass instanceQueryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass orderByElementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass queryResultEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass simpleBinaryExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass leftOperandEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass resultEntryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass correlationQueryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass timeBasedCorrelationQueryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum relationalOperatorsEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum orderByOperatorsEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ExtensionsPackageImpl() {
		super(eNS_URI, ExtensionsFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ExtensionsPackage init() {
		if (isInited) return (ExtensionsPackage)EPackage.Registry.INSTANCE.get(ExtensionsPackage.eNS_URI);

		// Obtain or create and register package.
		ExtensionsPackageImpl theExtensionsPackage = (ExtensionsPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new ExtensionsPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		EcorePackageImpl.init();

		// Obtain or create and register interdependencies
		HierarchyPackageImpl theHierarchyPackage = (HierarchyPackageImpl)(EPackage.Registry.INSTANCE.get(HierarchyPackage.eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(HierarchyPackage.eNS_URI) : HierarchyPackageImpl.eINSTANCE);

		// Step 1: create meta-model objects
		theExtensionsPackage.createPackageContents();
		theHierarchyPackage.createPackageContents();

		// Step 2: complete initialization
		theExtensionsPackage.initializePackageContents();
		theHierarchyPackage.initializePackageContents();

		return theExtensionsPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getQuery() {
		return queryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getQuery_Name() {
		return (EAttribute)queryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getQuery_Sources() {
		return (EAttribute)queryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getQuery_Distinct() {
		return (EAttribute)queryEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getQuery_Count() {
		return (EAttribute)queryEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getQuery_OutputElements() {
		return (EReference)queryEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSimpleSearchQuery() {
		return simpleSearchQueryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSimpleSearchQuery_MaxElements() {
		return (EAttribute)simpleSearchQueryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSimpleSearchQuery_OrderByExpresions() {
		return (EReference)simpleSearchQueryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSimpleSearchQuery_WhereExpressions() {
		return (EReference)simpleSearchQueryEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getInstanceQuery() {
		return instanceQueryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getInstanceQuery_Conditions() {
		return (EReference)instanceQueryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getOrderByElement() {
		return orderByElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getOrderByElement_Operator() {
		return (EAttribute)orderByElementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOrderByElement_Operand() {
		return (EReference)orderByElementEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getOrderByElement_SearchQuery() {
		return (EReference)orderByElementEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getQueryResult() {
		return queryResultEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getQueryResult_Query() {
		return (EReference)queryResultEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getQueryResult_ResultEntries() {
		return (EReference)queryResultEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSimpleBinaryExpression() {
		return simpleBinaryExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSimpleBinaryExpression_RightOperand() {
		return (EAttribute)simpleBinaryExpressionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSimpleBinaryExpression_Operator() {
		return (EAttribute)simpleBinaryExpressionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSimpleBinaryExpression_SearchQuery() {
		return (EReference)simpleBinaryExpressionEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSimpleBinaryExpression_InstanceQuery() {
		return (EReference)simpleBinaryExpressionEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSimpleBinaryExpression_Operand() {
		return (EReference)simpleBinaryExpressionEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLeftOperand() {
		return leftOperandEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLeftOperand_Name() {
		return (EAttribute)leftOperandEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getLeftOperand_Count() {
		return (EAttribute)leftOperandEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLeftOperand_Query() {
		return (EReference)leftOperandEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLeftOperand_Feature() {
		return (EReference)leftOperandEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLeftOperand_Type() {
		return (EReference)leftOperandEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getResultEntry() {
		return resultEntryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getResultEntry_Objects() {
		return (EAttribute)resultEntryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCorrelationQuery() {
		return correlationQueryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCorrelationQuery_CorrelationContainerURI() {
		return (EAttribute)correlationQueryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCorrelationQuery_DeltaTime() {
		return (EAttribute)correlationQueryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTimeBasedCorrelationQuery() {
		return timeBasedCorrelationQueryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getRelationalOperators() {
		return relationalOperatorsEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getOrderByOperators() {
		return orderByOperatorsEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtensionsFactory getExtensionsFactory() {
		return (ExtensionsFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		queryEClass = createEClass(QUERY);
		createEAttribute(queryEClass, QUERY__NAME);
		createEAttribute(queryEClass, QUERY__SOURCES);
		createEAttribute(queryEClass, QUERY__DISTINCT);
		createEAttribute(queryEClass, QUERY__COUNT);
		createEReference(queryEClass, QUERY__OUTPUT_ELEMENTS);

		simpleSearchQueryEClass = createEClass(SIMPLE_SEARCH_QUERY);
		createEAttribute(simpleSearchQueryEClass, SIMPLE_SEARCH_QUERY__MAX_ELEMENTS);
		createEReference(simpleSearchQueryEClass, SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS);
		createEReference(simpleSearchQueryEClass, SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS);

		instanceQueryEClass = createEClass(INSTANCE_QUERY);
		createEReference(instanceQueryEClass, INSTANCE_QUERY__CONDITIONS);

		orderByElementEClass = createEClass(ORDER_BY_ELEMENT);
		createEAttribute(orderByElementEClass, ORDER_BY_ELEMENT__OPERATOR);
		createEReference(orderByElementEClass, ORDER_BY_ELEMENT__OPERAND);
		createEReference(orderByElementEClass, ORDER_BY_ELEMENT__SEARCH_QUERY);

		queryResultEClass = createEClass(QUERY_RESULT);
		createEReference(queryResultEClass, QUERY_RESULT__QUERY);
		createEReference(queryResultEClass, QUERY_RESULT__RESULT_ENTRIES);

		simpleBinaryExpressionEClass = createEClass(SIMPLE_BINARY_EXPRESSION);
		createEAttribute(simpleBinaryExpressionEClass, SIMPLE_BINARY_EXPRESSION__RIGHT_OPERAND);
		createEAttribute(simpleBinaryExpressionEClass, SIMPLE_BINARY_EXPRESSION__OPERATOR);
		createEReference(simpleBinaryExpressionEClass, SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY);
		createEReference(simpleBinaryExpressionEClass, SIMPLE_BINARY_EXPRESSION__INSTANCE_QUERY);
		createEReference(simpleBinaryExpressionEClass, SIMPLE_BINARY_EXPRESSION__OPERAND);

		leftOperandEClass = createEClass(LEFT_OPERAND);
		createEAttribute(leftOperandEClass, LEFT_OPERAND__NAME);
		createEAttribute(leftOperandEClass, LEFT_OPERAND__COUNT);
		createEReference(leftOperandEClass, LEFT_OPERAND__QUERY);
		createEReference(leftOperandEClass, LEFT_OPERAND__FEATURE);
		createEReference(leftOperandEClass, LEFT_OPERAND__TYPE);

		resultEntryEClass = createEClass(RESULT_ENTRY);
		createEAttribute(resultEntryEClass, RESULT_ENTRY__OBJECTS);

		correlationQueryEClass = createEClass(CORRELATION_QUERY);
		createEAttribute(correlationQueryEClass, CORRELATION_QUERY__CORRELATION_CONTAINER_URI);
		createEAttribute(correlationQueryEClass, CORRELATION_QUERY__DELTA_TIME);

		timeBasedCorrelationQueryEClass = createEClass(TIME_BASED_CORRELATION_QUERY);

		// Create enums
		relationalOperatorsEEnum = createEEnum(RELATIONAL_OPERATORS);
		orderByOperatorsEEnum = createEEnum(ORDER_BY_OPERATORS);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EcorePackageImpl theEcorePackage = (EcorePackageImpl)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);

		// Add supertypes to classes
		simpleSearchQueryEClass.getESuperTypes().add(this.getQuery());
		instanceQueryEClass.getESuperTypes().add(this.getQuery());
		correlationQueryEClass.getESuperTypes().add(this.getSimpleSearchQuery());
		timeBasedCorrelationQueryEClass.getESuperTypes().add(this.getCorrelationQuery());

		// Initialize classes and features; add operations and parameters
		initEClass(queryEClass, Query.class, "Query", IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getQuery_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEAttribute(getQuery_Sources(), ecorePackage.getEString(), "sources", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEAttribute(getQuery_Distinct(), ecorePackage.getEBoolean(), "distinct", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEAttribute(getQuery_Count(), ecorePackage.getEBoolean(), "count", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEReference(getQuery_OutputElements(), this.getLeftOperand(), this.getLeftOperand_Query(), "outputElements", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);

		initEClass(simpleSearchQueryEClass, SimpleSearchQuery.class, "SimpleSearchQuery", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getSimpleSearchQuery_MaxElements(), ecorePackage.getEInt(), "maxElements", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEReference(getSimpleSearchQuery_OrderByExpresions(), this.getOrderByElement(), this.getOrderByElement_SearchQuery(), "orderByExpresions", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);
		initEReference(getSimpleSearchQuery_WhereExpressions(), this.getSimpleBinaryExpression(), this.getSimpleBinaryExpression_SearchQuery(), "whereExpressions", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);

		initEClass(instanceQueryEClass, InstanceQuery.class, "InstanceQuery", !IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getInstanceQuery_Conditions(), this.getSimpleBinaryExpression(), this.getSimpleBinaryExpression_InstanceQuery(), "conditions", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);

		initEClass(orderByElementEClass, OrderByElement.class, "OrderByElement", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getOrderByElement_Operator(), this.getOrderByOperators(), "operator", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEReference(getOrderByElement_Operand(), this.getLeftOperand(), null, "operand", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);
		initEReference(getOrderByElement_SearchQuery(), this.getSimpleSearchQuery(), this.getSimpleSearchQuery_OrderByExpresions(), "searchQuery", null, 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);

		initEClass(queryResultEClass, QueryResult.class, "QueryResult", !IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getQueryResult_Query(), this.getQuery(), null, "query", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);
		initEReference(getQueryResult_ResultEntries(), this.getResultEntry(), null, "resultEntries", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);

		initEClass(simpleBinaryExpressionEClass, SimpleBinaryExpression.class, "SimpleBinaryExpression", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getSimpleBinaryExpression_RightOperand(), theEcorePackage.getEJavaObject(), "rightOperand", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEAttribute(getSimpleBinaryExpression_Operator(), this.getRelationalOperators(), "operator", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEReference(getSimpleBinaryExpression_SearchQuery(), this.getSimpleSearchQuery(), this.getSimpleSearchQuery_WhereExpressions(), "searchQuery", null, 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);
		initEReference(getSimpleBinaryExpression_InstanceQuery(), this.getInstanceQuery(), this.getInstanceQuery_Conditions(), "instanceQuery", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);
		initEReference(getSimpleBinaryExpression_Operand(), this.getLeftOperand(), null, "operand", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);

		initEClass(leftOperandEClass, LeftOperand.class, "LeftOperand", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getLeftOperand_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEAttribute(getLeftOperand_Count(), ecorePackage.getEBoolean(), "count", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEReference(getLeftOperand_Query(), this.getQuery(), this.getQuery_OutputElements(), "query", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);
		initEReference(getLeftOperand_Feature(), theEcorePackage.getEStructuralFeature(), null, "feature", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);
		initEReference(getLeftOperand_Type(), theEcorePackage.getEClass(), null, "type", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED);

		initEClass(resultEntryEClass, ResultEntry.class, "ResultEntry", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getResultEntry_Objects(), theEcorePackage.getEJavaObject(), "objects", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);

		initEClass(correlationQueryEClass, CorrelationQuery.class, "CorrelationQuery", IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getCorrelationQuery_CorrelationContainerURI(), ecorePackage.getEString(), "correlationContainerURI", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);
		initEAttribute(getCorrelationQuery_DeltaTime(), ecorePackage.getEDouble(), "deltaTime", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED);

		initEClass(timeBasedCorrelationQueryEClass, TimeBasedCorrelationQuery.class, "TimeBasedCorrelationQuery", !IS_ABSTRACT, !IS_INTERFACE);

		// Initialize enums and add enum literals
		initEEnum(relationalOperatorsEEnum, RelationalOperators.class, "RelationalOperators");
		addEEnumLiteral(relationalOperatorsEEnum, RelationalOperators.LT_LITERAL);
		addEEnumLiteral(relationalOperatorsEEnum, RelationalOperators.GT_LITERAL);
		addEEnumLiteral(relationalOperatorsEEnum, RelationalOperators.EQ_LITERAL);
		addEEnumLiteral(relationalOperatorsEEnum, RelationalOperators.NEQ_LITERAL);
		addEEnumLiteral(relationalOperatorsEEnum, RelationalOperators.LIKE_LITERAL);

		initEEnum(orderByOperatorsEEnum, OrderByOperators.class, "OrderByOperators");
		addEEnumLiteral(orderByOperatorsEEnum, OrderByOperators.ASC_LITERAL);
		addEEnumLiteral(orderByOperatorsEEnum, OrderByOperators.DESC_LITERAL);
	}
} //ExtensionsPackageImpl
