/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

/**
 * Wizard for test cases
 * 
 * @author marcelop
 * @since 1.0.2
 */
abstract public class TestCaseNewWizard extends HyadesWizard implements ITestCaseWizard {
    private AttributeWizardPage attributeWizardPage;
    private ITestSuite testSuite;

    /**
     * Constructor for TestCaseNewWizard
     */
    public TestCaseNewWizard() {
        super();
        this.testSuite = null;
    }

    abstract protected String getType();

    /**
     * Returns the "name and description page" used by this wizard.
     * 
     * @return NameDescriptionWizardPage
     */
    protected AttributeWizardPage getAttributeWizardPage() {
        return attributeWizardPage;
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {
        attributeWizardPage = new AttributeWizardPage("nameDescription"); //$NON-NLS-1$
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#performFinish()
     */
    public boolean performFinish() {
        ITestSuite ts = getTestSuite();
        if (ts != null) {
            ITestCase testCase = TestCommonUtil.createTestCase(ts, getType(), false, getAttributeWizardPage().getItemName());
            testCase.setDescription(getAttributeWizardPage().getItemDescription());
            SaveManager.saveResource((TPFTestSuite) ts);
            return true;
        }

        openErrorMessage(TestCommonPlugin.getString("word.Error")); //$NON-NLS-1$
        return false;
    }

    private void openErrorMessage(String message) {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), SWT.ICON_ERROR | SWT.OK | SWT.SYSTEM_MODAL);
        messageBox.setText(TestCommonPlugin.getString("error.NullTestSuite")); //$NON-NLS-1$
        messageBox.setMessage(message);
        messageBox.open();
    }

    /*
     * @see org.eclipse.hyades.test.ui.wizard.ITestCaseWizard#setTestSuite(org.eclipse.hyades.models.common.facades.behavioral.ITestSuite)
     */
    public void setTestSuite(ITestSuite ts) {
        this.testSuite = ts;
    }

    /**
     * @return Returns the testSuite.
     */
    public ITestSuite getTestSuite() {
        return this.testSuite;
    }
}
