/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.runtime.datapool;

/**
 * An <i><b>equivalence class</b></i> is a logical grouping of 
 * {@link IDatapoolRecord records} within a {@link IDatapool datapool}.
 * All records in an equivalence class have the same uniform length as
 * records in all other equivalence classes associated with a single
 * {@link IDatapool datapool}.  Note that each equivalence class is a
 * named element with an associated name and ID.
 * 
 * @see	IDatapool
 * @see IDatapoolRecord
 */
public interface IDatapoolEquivalenceClass extends INamedElement
{
	
	/**
	 * The number of records in the equivalence class.
	 * 
	 * @return	The number of records in the equivalence class.
	 */
	public int getRecordCount();
	
	/**
	 * Access to the record contents at the specified zero based record index.
	 * 
	 * @param	record		The record contents at the specified zero based record index.
	 */
	public IDatapoolRecord getRecord(int record);

	/**
	 * Access to the {@link IDatapool datapool} that is the parent of this equivalence
	 * class.
	 * 
	 * @return	The {@link IDatapool datapool} that is the parent of this equivalence
	 *			class.
	 */
	public IDatapool getDatapool();
	
}