/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.sample.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.PartInitException;

import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationMapping;

/**
 * This is just a sample.  It is not a good practise to use classes from 
 * internal packages.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TestSuiteType2 
extends TestSuiteNewWizard
{
	/**
	 * Constructor for TestSuiteType2
	 */
	public TestSuiteType2()
	{
		super();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesGenericTestNewWizard#getType()
	 */
	protected String getType()
	{
		return "testSuiteType2";
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle("Location and file name");
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle("Attributes");
		getAttributeWizardPage().addActivationListener(this);
		addPage(getAttributeWizardPage());
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) throws PartInitException
	{
		IAssociationMapping mapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		mapping.setDefaultAssociationDescriptor(getType(), mapping.getAssociationDescriptor(getType(), "EditorExtension2"));
		
		super.openEditor(file);
	}	
}
