/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.internal.classloader;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.hyades.ui.internal.util.FileUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;

public class PathEntriesClassLoader 
extends FileClassLoader
{
    private Hashtable entryDataByPathEntry;
    private Vector directories;

	/**
	 * Examples of pathEntries:
	 * 		z:\test\myFile.zip;x\Dir
	 * 		z:\test\myFile.zip;k:\product\;y:\temp\aJar.jar
	 */
    public PathEntriesClassLoader(String pathEntries)
	{
		super(pathEntries);
		initialize(pathEntries);
	}

    public PathEntriesClassLoader(ClassLoader parent, String pathEntries)
	{
		super(parent, pathEntries);
		initialize(pathEntries);
	}

	private void initialize(String pathEntries)
	{
		entryDataByPathEntry = new Hashtable();
		directories = new Vector();
		
		if(pathEntries != null)
		{
			String[] auxEntries = StringUtil.tokenizer(pathEntries, File.pathSeparator, false);
			for(int i = 0, maxi = auxEntries.length; i < maxi; i++)
			{
				String entry = auxEntries[i].trim();
				File file = new File(entry);
				if(file.exists() && file.isDirectory())
					directories.add(entry);
				else
					entryDataByPathEntry.putAll(FileUtil.getZipEntryDataByZipEntryName(entry));
			}
		}		
	}
	
    protected byte[] loadClassBytes(String className)
	{
		byte[] ret = (byte[])entryDataByPathEntry.get(formatClassName(className));
		if(ret != null)
			return ret;
		
		for(Iterator i = directories.iterator(); i.hasNext();)
		{
			String dir = (String) i.next();			
			ret = super.loadClassBytes(className, dir);
			if(ret != null)
				return ret;
		}
		
		return null;
	}
}
