/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;

import org.eclipse.hyades.internal.execution.testgen.TestgenException;


/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TRCNodeAssembler
{	
	private TRCNodeDispatcher	dispatcher;
	private TRCNode				topNode;
	private TRCNode				currentNode = topNode;
	private int					previousDepth;
	
	public TRCNodeAssembler (TRCNodeDispatcher dispatcher)
	{
		this.dispatcher = dispatcher;
	}
	
	public void newElement (TRCElement element, int depth, String name)
		throws TestgenException
	{
		if (name.equals("TRACE"))
			return;
			
		TRCNode node = new TRCNode(name);
		// bind element with node
		element.setNode(node);
		node.setElement(element);
		
		if (depth == 2)
			topNode = node;
		else {
			if (depth < previousDepth) /* ascendant */ {
				node.setParentNode(currentNode.getParentNode().getParentNode());
			}
			else if (depth > previousDepth) /* descendant */ {
				node.setParentNode(currentNode);
			}
			else /* sibling */ {
				node.setParentNode(currentNode.getParentNode());
			}
			node.getParentNode().getSubNodes().addLast(node);
		}
		currentNode = node;
		previousDepth = depth;
	}

	public void completeElement (TRCElement element, int depth, String name)
		throws TestgenException
	{
		if (name.equals("TRACE"))
			return;
					
		TRCNode node = element.getNode();
			
		if (depth == 2)
			dispatcher.dispatch(node);
	}

}
