/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.*;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.util.internal.*;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.*;

public class ReferenceTable
	extends StatisticView
	implements IRefChangedListener
{
	/**
	 * 
	 *
	 */
	public class ClassStatisticFilter extends StatisticFilter {

		public ClassStatisticFilter() {
			super();
		}


		public boolean select(Viewer viewer, Object parent, Object element) {
			
			boolean flag = true;
			if(!(element instanceof TRCClass))
			  return true;
						
			String compareText = "";
			
			if (_noPattern)
				return true;
			
			if(element instanceof TRCClass)   
			   compareText = ((TRCClass)element).getName();
			   
			if (!_caseSensitive) {
				compareText = compareText.toLowerCase();
			}
			if (_exactMatch) {
				return compareText.compareTo(_prefix) == 0;
			}
			if (_prefix != "") {
				flag = compareText.startsWith(_prefix);
			}
			if (flag && _suffix != "") {
				flag = compareText.endsWith(_suffix);
			}
			if (flag) {
				for (int k = 0; k < _textList.size(); k++) {
					String str1 = (String) _textList.get(k);

					int index = compareText.lastIndexOf(str1);
					if (index == -1) {
						flag = false;
						break;
					}

					compareText = compareText.substring(index + str1.length());
				}
			}
			return flag;
		}
		
	}
	
	protected int	_drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
	

	/**
	 * 
	 */
	public class ObjReferenceSorter extends StatisticSorter {

		public ObjReferenceSorter() {
			super();
		}

		public int compare(Viewer viewer, Object e1, Object e2) {

			if (e1 instanceof TRCClass) {
				switch (_pos) {
					case 0 : //class name
					  return (int) _sortSequence * (int)((TRCClass)e1).getName().compareToIgnoreCase(((TRCClass)e2).getName());
					case 1 : //package name
					  return (int) _sortSequence * (int)((TRCClass)e1).getPackage().getName().compareToIgnoreCase(((TRCClass)e2).getPackage().getName());
					case 2 : //ref size
					{
						TRCClass c1 = (TRCClass) e1;
						TRCClass c2 = (TRCClass) e2;	
						
						return (int) _sortSequence * (int) ((c1.getTotalSize() - c1.getCollectedSize())
						                                    -(c2.getTotalSize() - c2.getCollectedSize()));

					}

					case 3 : //nb of references
						return 0;

				}
			}
			else if(e1 instanceof TRCHeapObject)
			{
				TRCHeapObject object1 = (TRCHeapObject)e1;
				TRCHeapObject object2 = (TRCHeapObject)e2;
				
				//TRCObject
				switch (_pos) {
					case 0 : //object name
						{
							TRCClass clas = object1.getIsA();
	                        
	                        String name1=PerftraceUtil.getClass(object1).getName();
	                        String name2=PerftraceUtil.getClass(object2).getName();
						    return (int) _sortSequence * (int)name1.compareToIgnoreCase(name2);							
						}
	
					case 1 : //package name
						{
							String name1=PerftraceUtil.getClass(object1).getPackage().getName();
							String name2=PerftraceUtil.getClass(object2).getPackage().getName();
						    return (int) _sortSequence * (int)name1.compareToIgnoreCase(name2);
						}
	
						case 2 : //ref size
						{
							int size1 = 0;
							int size2 = 0;
							
							if(showReferTo())
							{
								Object[] refs = object1.getRefTarget().toArray();
								for(int idx=0; idx<refs.length; idx++)
								{
									TRCObjectReference tmpRef = (TRCObjectReference) refs[idx];
									if(tmpRef instanceof TRCAggregatedObjectReference)
										size1 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize();
									else
									   size1 += tmpRef.getTarget().getSize();
									  
								}
								
								refs = object2.getRefTarget().toArray();
								for(int idx=0; idx<refs.length; idx++)
								{
									TRCObjectReference tmpRef = (TRCObjectReference) refs[idx];									
									if(tmpRef instanceof TRCAggregatedObjectReference)									
										size2 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize();
									else
									   size2 += tmpRef.getTarget().getSize();										
								}							
							}
							else
							{
								Object[] refs = object1.getRefOwner().toArray();
								for(int idx=0; idx<refs.length; idx++)
								{
									if(refs[idx] instanceof TRCAggregatedObjectReference)									
										size1 += ((TRCAggregatedObjectReference)refs[idx]).getOwnerSize();
								}
								
								refs = object2.getRefOwner().toArray();
								for(int idx=0; idx<refs.length; idx++)
								{
									if(refs[idx] instanceof TRCAggregatedObjectReference)									
										size2 += ((TRCAggregatedObjectReference)refs[idx]).getOwnerSize();
								}
							}
							
						    return (int) _sortSequence * (size1 - size2);
						}
	
						case 3 : //nb of references
						{
							int nb1 = 0;
							if(showReferTo())
							{
							   int size = object1.getRefTarget().size();
							   for(int idx=0; idx<size; idx++)
							   {
								  if(object1.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference)							   	
							   	    nb1 += ((TRCAggregatedObjectReference)object1.getRefTarget().get(idx)).getCount();
							   	  else
							   	    nb1++;  
							   }
							}
							else
							{
							   int size = object1.getRefOwner().size();
							   for(int idx=0; idx<size; idx++)
							   {
								  if(object1.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference)							   	
							   	     nb1 += ((TRCAggregatedObjectReference)object1.getRefOwner().get(idx)).getCount();
							   	  else
							   	    nb1++;   
							   }
							}
							
							int nb2 = 0;
							if(showReferTo())
							{
							   int size = object2.getRefTarget().size();
							   for(int idx=0; idx<size; idx++)
							   {
								   if(object2.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference)							   	
							   	      nb2 += ((TRCAggregatedObjectReference)object2.getRefTarget().get(idx)).getCount();
							   	   else
							   	     nb2++;   
							   }
							}
							else
							{
							   int size = object2.getRefOwner().size();
							   for(int idx=0; idx<size; idx++)
							   {
								  if(object2.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference)							   								   	
							   	   	nb2 += ((TRCAggregatedObjectReference)object2.getRefOwner().get(idx)).getCount();
							   	  else
							   	    nb2++; 	
							   }
							}
														
						    return (int) _sortSequence * (nb1 - nb2);						
						}							
				}
			}
			else //TRCAggregatedObjectReference
			{			
				TRCObjectReference ref1 = (TRCObjectReference)e1;
				TRCObjectReference ref2 = (TRCObjectReference)e2;	

				switch (_pos) {
					case 0 : //object name
						{
							TRCHeapObject object = ref1.getTarget();
							if(showReferTo())
							  object = ref1.getOwner();
							else 
							   object = ref1.getTarget();
							     
							TRCClass clas = PerftraceUtil.getClass(object);
	                        
	                        String name1=clas.getName();
							if (clas == object.getProcess().getClassClass())
								name1 = clas.getName();
							else
								name1 = clas.getName() + "." + object.getId();
								
							object = ref2.getTarget();
							if(showReferTo())
							  object = ref2.getOwner();	
							else
							  object = ref2.getTarget();
							    						  
							clas = PerftraceUtil.getClass(object);	                        
	                        
							String name2=clas.getName();
							if (clas == object.getProcess().getClassClass())
								name2 = clas.getName();
							else
								name2 = clas.getName() + "." + object.getId();
	
						    return (int) _sortSequence * (int)name1.compareToIgnoreCase(name2);							
						}
	
					case 1 : //package name
						{
							TRCObject object = ref1.getTarget();
							if(showReferTo())
							  object = ref1.getOwner();
							else
							  object = ref1.getTarget();
							    
	                        String name1=PerftraceUtil.getClass(object).getPackage().getName();
								
							object = ref2.getTarget();
							if(showReferTo())
							  object = ref2.getOwner();
							else
							   object = ref2.getTarget();
							     
							String name2=PerftraceUtil.getClass(object).getPackage().getName();
	
						    return (int) _sortSequence * (int)name1.compareToIgnoreCase(name2);
						}
	
						case 2 : //ref size
						{
							int size1 = 0;
							int size2 = 0;
							
							if(showReferTo())
							{
								Object[] refs = ref1.getOwner().getRefTarget().toArray();
								for(int idx=0; idx<refs.length; idx++)
								{
									TRCObjectReference tmpRef = (TRCObjectReference)refs[idx];									
									if(tmpRef instanceof TRCAggregatedObjectReference)							   										
										size1 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize();
									else
									   size1 += tmpRef.getTarget().getSize();
								}
								
								refs = ref2.getOwner().getRefTarget().toArray();
								for(int idx=0; idx<refs.length; idx++)
								{
									TRCObjectReference tmpRef = (TRCObjectReference)refs[idx];									
									if(tmpRef instanceof TRCAggregatedObjectReference)							   																			
									   size2 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize();
									else
									   size2 += tmpRef.getTarget().getSize();
								}							
							}
							else
							{
								Object[] refs = ref1.getTarget().getRefOwner().toArray();
								for(int idx=0; idx<refs.length; idx++)
								{
									TRCObjectReference tmpRef = (TRCObjectReference)refs[idx];
									if(tmpRef instanceof TRCAggregatedObjectReference)							   																			
									  size1 += ((TRCAggregatedObjectReference)tmpRef).getOwnerSize();
									else  
									  size1+= tmpRef.getOwner().getSize();
								}
								
								refs = ref2.getTarget().getRefOwner().toArray();
								for(int idx=0; idx<refs.length; idx++)
								{
									TRCObjectReference tmpRef = (TRCObjectReference)refs[idx];									
									if(tmpRef instanceof TRCAggregatedObjectReference)							   																			
									   size2 += ((TRCAggregatedObjectReference)tmpRef).getOwnerSize();
									else
									   size2 += tmpRef.getOwner().getSize();   
								}
							}
							
						    return (int) _sortSequence * (size1 - size2);
						}
	
						case 3 : //nb of references
						{
							int nb1 = 0;
							if(showReferTo())
							{
							   int size = ref1.getOwner().getRefTarget().size();
							   for(int idx=0; idx<size; idx++)
							   {
							   	   if(ref1.getOwner().getRefTarget().get(idx) instanceof TRCAggregatedObjectReference)
							   	      nb1 += ((TRCAggregatedObjectReference)ref1.getOwner().getRefTarget().get(idx)).getCount();
							   	   else
							   	     nb1++;   
							   }							   
							}
							else
							{
								int size = ref1.getTarget().getRefOwner().size();								
							   for(int idx=0; idx<size; idx++)
							   {
								   if(ref1.getTarget().getRefOwner().get(idx) instanceof TRCAggregatedObjectReference)							   	
							   	      nb1 += ((TRCAggregatedObjectReference)ref1.getTarget().getRefOwner().get(idx)).getCount();
							   	   else
							   	      nb1++;   
							   }								
							}
							
							int nb2 = 0;
							if(showReferTo())
							{
							   int size = ref2.getOwner().getRefTarget().size();
							   for(int idx=0; idx<size; idx++)
							   {
								   if(ref2.getOwner().getRefTarget().get(idx) instanceof TRCAggregatedObjectReference)							   	
							   	   	nb2 += ((TRCAggregatedObjectReference)ref2.getOwner().getRefTarget().get(idx)).getCount();
							   	   else
							   	     nb2++;	
							   }							   
							}
							else
							{
							   int size = ref2.getTarget().getRefOwner().size();								
							   for(int idx=0; idx<size; idx++)
							   {
								  if(ref2.getTarget().getRefOwner().get(idx) instanceof TRCAggregatedObjectReference)							   	
							   	    nb2 += ((TRCAggregatedObjectReference)ref2.getTarget().getRefOwner().get(idx)).getCount();
							   	  else
							   	    nb2++;      
							   }								
							}
							
						    return (int) _sortSequence * (nb1 - nb2);
						}	
						case 4 : //nb of instances for this reference
						{
							if(ref1 instanceof TRCAggregatedObjectReference && ref2 instanceof TRCAggregatedObjectReference)
   						    	return (int) _sortSequence * (((TRCAggregatedObjectReference)ref1).getCount() - ((TRCAggregatedObjectReference)ref2).getCount());
 						}
				}
			}

			return 0;
		}

	}

	/**
	 * 
	 */
	public class ObjReferenceContentProvider
		implements ITreeContentProvider {

		public void dispose() {
		}

		public Object getParent(Object element) {
			
			if(element instanceof TRCClass)
			  return null;
			  
			if(element instanceof TRCHeapObject)
			   return ((TRCHeapObject)element).getIsA();  
			  
			return null;
		}

		public void inputChanged(
			Viewer viewer,
			Object oldInput,
			Object newInput) {
		}

		public Object[] getElements(Object inputElement) {						
			return PerftraceUtil.getAllClasses(_page.getMOFObject());
		}

		public Object[] getChildren(Object element) {
			tmpList.clear();
			
			if(showReferTo())
			{
				if (element instanceof TRCClass)
				{
					TRCHeapObject obj = null;
					Object[] classObjects = ((TRCClass) element).getClassObjects().toArray();
					for(int idx=0; idx<classObjects.length; idx++)
					{
						TRCObject tmpObject = (TRCObject)classObjects[idx];						
						if(tmpObject instanceof TRCHeapObject)
						{
							obj = (TRCHeapObject)tmpObject;
							break;							
						}
					}
					
					if(obj != null && obj.getRefTarget().size() > 0)
					  tmpList.add(obj);
					
					Object[] objects = ((TRCClass) element).getObjects().toArray();
					for(int idx=0; idx<objects.length; idx++)
					{
						TRCObject tmpObject = (TRCObject)objects[idx];
						if(tmpObject instanceof TRCHeapObject)
						{
							if(((TRCHeapObject)tmpObject).getRefTarget().size() > 0)//obj.getIsA() == element &&
							   tmpList.add(tmpObject);							
						}
					}
				}
				else if(element instanceof TRCHeapObject)
				{
					tmpList.addAll(((TRCHeapObject)element).getRefTarget());
				}
				else //TRCAggregatedObjectReference
				{
					tmpList.addAll(((TRCObjectReference)element).getOwner().getRefTarget());
				}				
			}
			else
			{
				if (element instanceof TRCClass)
				{
					TRCHeapObject obj = null;
					Object[] classObjects = ((TRCClass) element).getClassObjects().toArray();
					for(int idx=0; idx<classObjects.length; idx++)
					{
						TRCObject tmpObject = (TRCObject)classObjects[idx];						
						if(tmpObject instanceof TRCHeapObject)
						{
							obj = (TRCHeapObject)tmpObject;
							break;							
						}
					}
					
					if(obj != null && obj.getRefOwner().size() > 0)
					  tmpList.add(obj);
					
					Object[] objects = ((TRCClass) element).getObjects().toArray();
					for(int idx=0; idx<objects.length; idx++)
					{
						TRCObject tmpObject = (TRCObject)objects[idx];	
						if(tmpObject instanceof TRCHeapObject)		
						{	
							if(tmpObject.getIsA() == element && ((TRCHeapObject)tmpObject).getRefOwner().size() > 0)
							   tmpList.add(objects[idx]);
						}
					}
				}
				else if(element instanceof TRCHeapObject)
				{
					tmpList.addAll(((TRCHeapObject)element).getRefOwner());
				}
				else //TRCAggregatedObjectReference
				{
					tmpList.addAll(((TRCObjectReference)element).getTarget().getRefOwner());
				}								
			}
			
			return tmpList.toArray();
		}

		public boolean hasChildren(Object element) {
			
		  return (getChildren(element).length > 0);
			  
		}
	}

	/**
	 * 
	 */
	public class ObjReferenceLabelProvider
		extends LabelProvider
		implements ITableLabelProvider {
		protected StatisticView _viewer;

		public ObjReferenceLabelProvider(StatisticView viewer) {
			super();
			_viewer = viewer;
		}

		public Image getColumnImage(Object obj, int col) {
			return null;
		}

		public String getColumnText(Object obj, int col) {

			int pos =
				StatisticTableColumnInfo
					.getStatisticTableColumnInfo(
						_viewer.getTable().getColumn(col))
					.getColumnData()
					.getInitalPos();

			if (obj instanceof TRCClass) {
				switch (pos) {
					case 0 : //class name
						return ((TRCClass) obj).getName();

					case 1 : //package name
						return PerftraceUtil.getPackageName(((TRCClass) obj).getPackage(), _page.getMOFObject()).toString();

					case 2 : //ref size
						return String.valueOf(((TRCClass)obj).getTotalSize()-((TRCClass)obj).getCollectedSize());

					case 3 : //nb of references
						return "";

				}
			}
			
			else if(obj instanceof TRCHeapObject)
			{

                TRCHeapObject object = (TRCHeapObject)obj;
				switch (pos) {
					case 0 : //object name
						{
							TRCClass clas = PerftraceUtil.getClass(object);
							if(clas == object.getIsA())
							   return clas.getName() + "." + object.getId();
							   
							return clas.getName();
						}
	
					case 1 : //package name
						{
							return PerftraceUtil.getPackageName(PerftraceUtil.getClass(object).getPackage(), _page.getMOFObject()).toString();							
						}
	
						case 2 : //ref size
						{
							int size = object.getSize(); //total size
							
							if(size != 0)
							  return String.valueOf(size);
							  
							//collect statistic information mode
							if(showReferTo())
							{
							   if(object.getRefTarget().size() > 0 && object.getRefTarget().get(0) instanceof TRCAggregatedObjectReference)
							   {
							   	   return String.valueOf(((TRCAggregatedObjectReference)object.getRefTarget().get(0)).getTargetSize());
	   	   
							   }
							   else
							   {
									TRCClass clas = PerftraceUtil.getClass(object);
									int instSize = clas.getTotalInstances();
									if(instSize == 0) instSize = 1;
									
									return String.valueOf((int) clas.getTotalSize()/instSize);
							   	
							   }
							      
							}
							else
							{
							   if(object.getRefOwner().size() > 0 && object.getRefOwner().get(0) instanceof TRCAggregatedObjectReference)
							   {
							   	   return String.valueOf(((TRCAggregatedObjectReference)object.getRefOwner().get(0)).getOwnerSize());
							   }
							   else
							   {
									TRCClass clas = PerftraceUtil.getClass(object);
									int instSize = clas.getTotalInstances();
									if(instSize == 0) instSize = 1;
									
									return String.valueOf((int) clas.getTotalSize()/instSize);
							   	
							   }
								
							}
						}
	
						case 3 : //nb of references
						{
							
							if(showReferTo())
							{								
							   int nb = 0;
							   int size = ((TRCHeapObject)obj).getRefTarget().size();
							   for(int idx=0; idx<size; idx++)
							   {
									if(object.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference)							   	
								   	   nb += ((TRCAggregatedObjectReference)object.getRefTarget().get(idx)).getCount();
									else
									  nb++;	 
								   	   
							   }
							   
							   if(nb > 0)
									return  TString.change(TraceUIPlugin.getString("REF_BY_DETAIL"), "%1", String.valueOf(nb));
									
							   return "";		
																									   
							}
							else
							{
							   int nb = 0;
							   int size = ((TRCHeapObject)obj).getRefOwner().size();
							   for(int idx=0; idx<size; idx++)
							   {
							   	   if(object.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference)
							   	   	 nb += ((TRCAggregatedObjectReference)object.getRefOwner().get(idx)).getCount();
							   	   else
							   	     nb++;	 
							   }
							   
							   if(nb > 0)
									return  TString.change(TraceUIPlugin.getString("REF_TO_DETAIL"), "%1", String.valueOf(nb));
								
							   return "";																									
							}
							
						}
							
				}
			}
			else //TRCObjectReference
			{
				TRCObjectReference ref = (TRCObjectReference) obj;
				switch (pos) {
					case 0 : //object name
						{	
							TRCObject object = null;
							if(showReferTo())
							  object = ref.getOwner();
							else
							    object = ref.getTarget();
							    
							TRCClass clas = PerftraceUtil.getClass(object);						
							if (clas == object.getIsA())
								return clas.getName() + "." + object.getId();
	
							return clas.getName();
						}
	
					case 1 : //package name
						{
							TRCObject object = null;
							if(showReferTo())
							  object = ref.getOwner();
							else
							  object = ref.getTarget();  
											    
							return PerftraceUtil.getPackageName(PerftraceUtil.getClass(object).getPackage(), _page.getMOFObject()).toString();							
						}

						case 2 : //ref size
						{
							int size = 0;
							
							if(ref instanceof TRCAggregatedObjectReference)
							{
								if(showReferTo())
								{
								   size = ((TRCAggregatedObjectReference)ref).getOwnerSize();								
								}
								else
								{
								   size = ((TRCAggregatedObjectReference)ref).getTargetSize();
								}								
							}
							else
							{
								if(showReferTo())
								{
								   size = ref.getOwner().getSize();								
								}
								else
								{
								   size = ref.getTarget().getSize();
								}																
							}
							
							return String.valueOf(size);
						}
	
						case 3 : //nb of references
						{							
							if(showReferTo())
							{
							   int nb = 0;
							   Object[] list = ref.getOwner().getRefTarget().toArray();
							   int size = list.length;
							   for(int idx=0; idx<size; idx++)
							   {
							   	   if(list[idx] instanceof TRCAggregatedObjectReference)
							   	   	nb += ((TRCAggregatedObjectReference)list[idx]).getCount();
							   	   else 
							   	     nb++;	
							   }
							   
							   if(nb > 0)
									return  TString.change(TraceUIPlugin.getString("REF_BY_DETAIL"), "%1", String.valueOf(nb));
									
							   return "";		
																									   
							}
							else
							{
								int nb = 0;
								Object[] list = ref.getTarget().getRefOwner().toArray();
								int size = list.length;
							    for(int idx=0; idx<size; idx++)
							    {
								   if(list[idx] instanceof TRCAggregatedObjectReference)							   	
							   	   	 nb += ((TRCAggregatedObjectReference)list[idx]).getCount();
							   	   else
							   	     nb++;	 
							    }
								
							   if(nb > 0)
									return  TString.change(TraceUIPlugin.getString("REF_TO_DETAIL"), "%1", String.valueOf(nb));
									
							   return "";		
																							
							}							
							
						}

						case 4 : //nb of instances for this reference
						{							
							if(showReferTo())
							{
							   if(ref instanceof TRCAggregatedObjectReference)
							   {
									int size = ((TRCAggregatedObjectReference)ref).getCount();
								   
									if( size > 1 ) 
									{
										 return TString.change(TString.change(TraceUIPlugin.getString("REF_BY_DET1"), "%1", String.valueOf(size))
																	 , "%2", PerftraceUtil.getClass(ref.getTarget()).getName());
									}
							   	
							   }
									
							   return "";		
							   
							}
							else
							{
								if(ref instanceof TRCAggregatedObjectReference)
								{
									int size = ((TRCAggregatedObjectReference)ref).getCount();
							   
									if( size > 1 ) 
									{
										 return TString.change(TString.change(TraceUIPlugin.getString("REF_TO_DET1"), "%1", PerftraceUtil.getClass(((TRCAggregatedObjectReference)obj).getOwner()).getName())
																	 , "%2", String.valueOf(size));
							   	
									}
									
								}
								
							   return "";		
								
							}							 
						}
				}
				
			}

			return "";
		}
	}
	
	/**
	 * 
	 */
	class ReferenceTreeViewer extends TableTreeViewer {
		public ReferenceTreeViewer(Composite parent) {
			super(parent);
		}

		public ReferenceTreeViewer(TableTree table) {
			super(table);
		}

		public void expandItem(TableTreeItem item) {
			item.setExpanded(true);
			createChildren(item);

		}

	}
	protected Composite createTable(Composite parent, int options) {
		return new TableTree(parent, options);
	}

	public ReferenceTable(Composite parent, TraceViewerPage page) {
		super(parent, page);
		_viewerFilter = new ClassStatisticFilter();				

		TraceUIPlugin.getDefault().addRefChangedEventListener(this);

	}

	/**
	 * getClassColumnsPerferencesKey returns the string key used to find the
	 * column preferences information in the preferences store.
	 * @return java.lang.String key name
	 */
	public String getColumnsPreferencesKey() {
		// Note this string is not to be translated and must be changed whenever the 
		// default columns template is changed by adding, removing or renaming columns.
		// Changing the version will result in the default preferences being used.
		return "Ref63";

	}
	public String getDefaultColumnsTemplate() {
		//Class Columns Data
		_drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
		
		String name = TraceUIPlugin.getString("STR_REFEREE");
		if(showReferTo())
		    name = TraceUIPlugin.getString("STR_REFERANDS");
		    
		String executionColumn =
			    name
				+ ":0:"
				+ String.valueOf(
					ColumnData.NONDELETABLE
						| ColumnData.IS_VISIBLE
						| ColumnData.NONMOVABLE)
				+ ":left:200,"
				+ TraceUIPlugin.getString("STR_ST_PACKAGE") + ":1:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":left:150,"
				+ TraceUIPlugin.getString("STR_REF_SIZE")	+ ":2:"
				+ String.valueOf(ColumnData.IS_VISIBLE)	+ ":right:100,"
				+ TraceUIPlugin.getString("STR_NB_REF") + ":3:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":left:170,"
				+ TraceUIPlugin.getString("STR_OBJ_REF_DETAIL") + ":4:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":left:350";
				

		return executionColumn;
	}
	protected IContentProvider getContentProvider() {
		return new ObjReferenceContentProvider();
	}
	
	public LabelProvider getTableLabelProvider()
	{
		return new ObjReferenceLabelProvider(this);
	}
	

	public Table getTable() {
		return ((TableTree) getTableViewer().getControl()).getTable();
	}

	protected StructuredViewer createTableViewer(Composite table) {
		ReferenceTreeViewer tv = new ReferenceTreeViewer((TableTree) table);
		return (StructuredViewer) tv;
	}

	protected void handleSelectionEvent() {
		((ReferenceTablePage) getTraceViewerPage()).openSource().setEnabled(
			false);

		ITraceSelection model = UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
		
		if (model.size() > 0)
		{
			Object sel = model.getFirstElement();
			
			if(!(sel instanceof TRCPackage))
				((ReferenceTablePage) getTraceViewerPage()).openSource().setEnabled(true);
				
            select(sel);
			
			// If the selection is an object then turn the selection into the class of the object
			if (sel instanceof TRCObject) {
				
				sel = ((TRCObject)sel).getIsA();
			}
			else if (sel instanceof TRCClass) {
				select((TRCClass) sel);
			}
			
		}
	}

	/**
	 * Called when the context menu is about to open.
	 * @see IFillMenuTarget#fillContextMenu
	 */
	public void menuAboutToShow(IMenuManager menu) {
		menu.add(fSeparator);

		menu.add(getUpdateAction());

		menu.add(fSeparator);
		menu.add(
			getChooseColumnsAction(
				getColumnDataList(),
				getColumnsPreferencesKey()));
	}

	private void select(Object sel) {
		
		TRCClass cls = null;
		TRCObject obj = null;
		
		if(sel instanceof TRCClass)
		{
			cls = (TRCClass)sel;
		}
		else if(sel instanceof TRCObject)
		{
			obj = (TRCObject)sel;
		    cls = obj.getIsA();			  			  
		}
		
		if(cls == null)
		  return;
		  
		TableTree table = (TableTree) getTableViewer().getControl();

		TableTreeItem[] items = table.getItems();
		for (int idx = 0; idx < items.length; idx++) {
			TableTreeItem item = items[idx];
			if (item.getData().equals(cls))
			{
				((ReferenceTreeViewer) getTableViewer()).expandItem(item);
				
				if(obj == null)
				{
					table.setSelection(new TableTreeItem[] { item });
					setNewSelection();
					return;
				}
				
				TableTreeItem[] childItems = item.getItems();
	
				for (int i = 0; i < childItems.length; i++) {
					TableTreeItem childItem = childItems[i];
	  				if (childItem.getData().equals(obj)) {
							table.setSelection(new TableTreeItem[] { childItem });
							setNewSelection();
							return;
					}
				}
				
			}
		}
		
	}

	public void updateButtons() {

	}

	protected void updateDetailsPane() {
		int selIndex = getTable().getSelectionIndex();
		if (selIndex < 0) {
			return;
		}

		Item item = getTable().getItem(selIndex);
		Object itemData = item.getData();

		if (itemData == null) {
			return;
		}
		if (itemData != null && itemData instanceof TableTreeItem) {
			itemData = ((TableTreeItem) itemData).getData();
		}
	}

	public void updateModelSelection() {
		
		ISelection selection = getTableViewer().getSelection();
		if(selection != null && !selection.isEmpty())
		{
			Object itemData = ((IStructuredSelection)selection).getFirstElement();

			if(itemData instanceof TRCObjectReference)
			{  
			   if(showReferTo())
				   itemData = ((TRCObjectReference)itemData).getOwner();
			   else	   
				   itemData = ((TRCObjectReference)itemData).getTarget();			   
			}
			
			notifyViewSelectionChanged(this,itemData);
//			UIPlugin.getDefault().getSelectionModel(
//				_page.getMOFObject()).add(
//				itemData);
//	
//			ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
//			event.setSource(_page.getMOFObject());
//			UIPlugin.getDefault().notifyViewSelectionChangedListener(event);			
		}		
	}

	public void update() {
		
		_drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
		
		if (_firstTime) {
			getTableViewer().addFilter(getViewerFilter());
			_firstTime = false;
			Table table = getTable();
			table.setLinesVisible(false);
			TableColumn firstColumn = table.getColumn(0);
						
			_viewerSorter = new ObjReferenceSorter();
			
			getViewerSorter().setSortedColumn(firstColumn);
			getTableViewer().setSorter(getViewerSorter());
		}
		// set the input of the viewer
		getTableViewer().setInput(_page.getMOFObject());
		getTableViewer().refresh();
		
		handleSelectionEvent();
		
	}

	public void dispose() {
		TraceUIPlugin.getDefault().removeRefChangedEventListener(this);

		super.dispose();
	}

	public void handleRefChangedEvent() {
		
		_drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.OBJ_REF_OPTION);
				
		Table table = getTable();
		TableColumn firstColumn = table.getColumn(0);
		
		String text = firstColumn.getText();
		String name = TraceUIPlugin.getString("STR_REFEREE");
		if(showReferTo())
		    name = TraceUIPlugin.getString("STR_REFERANDS");
		
		if (text.startsWith(">") || text.startsWith("<"))
		{
			firstColumn.setText(text.substring(0,1) + name);
		}
		else
			firstColumn.setText(name);		  
		
		Action referands =
			((ReferenceTablePage) getTraceViewerPage()).referands();
		Action referee = ((ReferenceTablePage) getTraceViewerPage()).referee();
		int ref =
			TraceUIPlugin.getDefault().getPreferenceStore().getInt(
				TraceConstants.OBJ_REF_OPTION);
		if (referands != null)
			referands.setChecked(ref == TraceConstants.OBJ_REF_REFERANDS);
		if (referee != null)
			referee.setChecked(ref == TraceConstants.OBJ_REF_REFEREES);

		update();

	}

    private boolean showReferTo()
    {
    	return _drawmode == TraceConstants.OBJ_REF_REFERANDS;
    }
    
	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event)
	{
		Object  source = event.getSource();
		if(source!=this){	
			handleSelectionEvent();
		}
	}
	
	public boolean isEmpty()
	{
		if (PerftraceUtil.getAllClasses(_page.getMOFObject()).length > 0)
			return false;
		return true;
	}
    
}